/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.MutableLifecycleHolder;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.NamedAliasMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject
public class AbstractKernelDeployment
extends JBossObject
implements KernelDeployment,
MutableLifecycleHolder,
Serializable {
    private static final long serialVersionUID = 2L;
    protected String name;
    protected boolean installed;
    protected transient List<KernelControllerContext> installedContexts = new CopyOnWriteArrayList<KernelControllerContext>();
    protected Boolean scoped;
    protected Set<AnnotationMetaData> annotations;
    protected List<BeanMetaDataFactory> beanFactories;
    protected ClassLoaderMetaData classLoader;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;
    protected LifecycleMetaData stop;
    protected LifecycleMetaData destroy;
    protected ControllerMode mode;
    protected Set<NamedAliasMetaData> aliases;

    public void setBeans(List beans) {
        this.beanFactories = beans;
        this.flushJBossObjectCache();
    }

    @ManagementProperty(managed=true)
    public void setBeanFactories(List<BeanMetaDataFactory> beanFactories) {
        this.beanFactories = beanFactories;
        this.flushJBossObjectCache();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
        this.flushJBossObjectCache();
    }

    public void addInstalledContext(KernelControllerContext context) {
        this.installedContexts.add(context);
        this.flushJBossObjectCache();
    }

    public List<KernelControllerContext> getInstalledContexts() {
        return this.installedContexts;
    }

    public void removeInstalledContext(KernelControllerContext context) {
        this.installedContexts.remove(context);
        this.flushJBossObjectCache();
    }

    public List<BeanMetaData> getBeans() {
        List<BeanMetaDataFactory> factories = this.getBeanFactories();
        if (factories == null || factories.size() == 0) {
            return null;
        }
        ArrayList<BeanMetaData> result = new ArrayList<BeanMetaData>(factories.size());
        for (BeanMetaDataFactory factory : factories) {
            List beans = factory.getBeans();
            for (BeanMetaData bmd : beans) {
                if (this.annotations != null && !this.annotations.isEmpty()) {
                    HashSet<AnnotationMetaData> annotationsBMD = bmd.getAnnotations();
                    if (annotationsBMD == null) {
                        annotationsBMD = new HashSet<AnnotationMetaData>();
                        bmd.setAnnotations(annotationsBMD);
                    }
                    annotationsBMD.addAll(this.annotations);
                }
                if (!(bmd instanceof AbstractBeanMetaData)) continue;
                AbstractBeanMetaData bean = (AbstractBeanMetaData)bmd;
                if (bean.getCreate() == null && this.getCreate() != null) {
                    bean.setCreate(this.getCreate());
                }
                if (bean.getStart() == null && this.getStart() != null) {
                    bean.setStart(this.getStart());
                }
                if (bean.getStop() == null && this.getStop() != null) {
                    bean.setStop(this.getStop());
                }
                if (bean.getDestroy() == null && this.getDestroy() != null) {
                    bean.setDestroy(this.getDestroy());
                }
                if (bean.getMode() != null || this.getMode() == null) continue;
                bean.setMode(this.getMode());
            }
            result.addAll(beans);
        }
        return result;
    }

    public Boolean getScoped() {
        return this.scoped;
    }

    public void setScoped(Boolean scoped) {
        this.scoped = scoped;
    }

    public Set<AnnotationMetaData> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<AnnotationMetaData> annotations) {
        this.annotations = annotations;
    }

    public List<BeanMetaDataFactory> getBeanFactories() {
        return this.beanFactories;
    }

    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public LifecycleMetaData getCreate() {
        return this.create;
    }

    public void setCreate(LifecycleMetaData create) {
        create.setState(ControllerState.CREATE);
        this.create = create;
    }

    public LifecycleMetaData getStart() {
        return this.start;
    }

    public void setStart(LifecycleMetaData start) {
        start.setState(ControllerState.START);
        this.start = start;
    }

    public LifecycleMetaData getStop() {
        return this.stop;
    }

    public void setStop(LifecycleMetaData stop) {
        stop.setState(ControllerState.START);
        this.stop = stop;
    }

    public LifecycleMetaData getDestroy() {
        return this.destroy;
    }

    public void setDestroy(LifecycleMetaData destroy) {
        destroy.setState(ControllerState.CREATE);
        this.destroy = destroy;
    }

    public Set<NamedAliasMetaData> getAliases() {
        return this.aliases;
    }

    public void setAliases(Set<NamedAliasMetaData> aliases) {
        this.aliases = aliases;
    }

    public ControllerMode getMode() {
        return this.mode;
    }

    public void setMode(ControllerMode mode) {
        this.mode = mode;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" installed=").append(this.installed);
        if (this.classLoader != null) {
            buffer.append(" classLoader=").append((Object)this.classLoader);
        }
        if (this.beanFactories != null) {
            buffer.append(" beanFactories=").append(this.beanFactories);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.installedContexts = new CopyOnWriteArrayList<KernelControllerContext>();
    }
}

