/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.plugins.policy.AbstractPolicyMetaData;
import org.jboss.beans.metadata.spi.policy.BindingMetaData;
import org.jboss.beans.metadata.spi.policy.PolicyMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class BindingTestCase
extends AbstractXMLTest {
    public BindingTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return BindingTestCase.suite(BindingTestCase.class);
    }

    public void testBindingWithNoName() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("BindingWithNoName.xml", AbstractPolicyMetaData.class);
        BindingTestCase.assertFalse((boolean)policy.getBindings().isEmpty());
        BindingTestCase.assertEquals((int)1, (int)policy.getBindings().size());
        BindingMetaData binding = (BindingMetaData)policy.getBindings().iterator().next();
        BindingTestCase.assertNotNull((Object)binding.getValue());
    }

    public void testBindingWithPlainValue() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("BindingWithPlainValue.xml", AbstractPolicyMetaData.class);
        BindingTestCase.assertFalse((boolean)policy.getBindings().isEmpty());
        BindingTestCase.assertEquals((int)1, (int)policy.getBindings().size());
        BindingMetaData binding = (BindingMetaData)policy.getBindings().iterator().next();
        BindingTestCase.assertNotNull((Object)binding.getName());
        BindingTestCase.assertNotNull((Object)binding.getValue());
        this.assertInstanceOf(binding.getValue(), StringValueMetaData.class);
    }

    public void testBindingWithComplexValue() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("BindingWithComplexValue.xml", AbstractPolicyMetaData.class);
        BindingTestCase.assertFalse((boolean)policy.getBindings().isEmpty());
        BindingTestCase.assertEquals((int)1, (int)policy.getBindings().size());
        BindingMetaData binding = (BindingMetaData)policy.getBindings().iterator().next();
        BindingTestCase.assertNotNull((Object)binding.getName());
        BindingTestCase.assertNotNull((Object)binding.getValue());
        this.assertInstanceOf(binding.getValue(), StringValueMetaData.class);
    }
}

