/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.kernel.plugins.annotations.AnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ValueUtil;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation>
extends JBossObject
implements AnnotationPlugin<T, C> {
    private Class<C> annotation;
    private Set<ElementType> types;

    protected AbstractAnnotationPlugin(Class<C> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation!");
        }
        this.annotation = annotation;
        this.types = new HashSet<ElementType>();
        Target target = annotation.getAnnotation(Target.class);
        if (target != null) {
            List<ElementType> list = Arrays.asList(target.value());
            for (ElementType type : list) {
                if (this.isElementTypeSupported(type)) {
                    this.types.add(type);
                    continue;
                }
                this.log.warn((Object)("Unsupported type " + (Object)((Object)type) + " on annotation " + annotation));
            }
        }
    }

    protected static boolean isAttributePresent(String value) {
        return ValueUtil.isAttributePresent(value);
    }

    protected abstract boolean isElementTypeSupported(ElementType var1);

    @Override
    public Set<ElementType> getSupportedTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    @Override
    public Class<C> getAnnotation() {
        return this.annotation;
    }

    protected boolean isMetaDataAlreadyPresent(T info, C annotation, KernelControllerContext context) {
        return this.isMetaDataAlreadyPresent(info, annotation, context.getBeanMetaData());
    }

    protected boolean isMetaDataAlreadyPresent(T info, C annotation, BeanMetaData beanMetaData) {
        return false;
    }

    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, MetaData retrieval, C annotation, KernelControllerContext context) throws Throwable {
        return this.internalApplyAnnotation(info, annotation, context);
    }

    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, KernelControllerContext context) throws Throwable {
        return this.internalApplyAnnotation(info, annotation, context.getBeanMetaData());
    }

    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, BeanMetaData beanMetaData) throws Throwable {
        this.log.warn((Object)("Probably missing annotation apply implementation: " + this));
        return Collections.emptyList();
    }

    @Override
    public final void applyAnnotation(T info, MetaData retrieval, MetaDataVisitor visitor) throws Throwable {
        List<MetaDataVisitorNode> nodes;
        boolean trace = this.log.isTraceEnabled();
        Class<C> annotationClass = this.getAnnotation();
        Annotation annotation = retrieval.getAnnotation(annotationClass);
        if (annotation == null) {
            if (trace) {
                this.log.trace((Object)("No annotation: " + annotationClass.getName()));
            }
            return;
        }
        if (this.isMetaDataAlreadyPresent(info, annotation, visitor.getControllerContext())) {
            if (trace) {
                this.log.trace((Object)("MetaDataAlreadyPresent, ignoring " + annotation));
            }
            return;
        }
        if (trace) {
            this.log.trace((Object)("Applying annotation: " + annotation));
        }
        if ((nodes = this.internalApplyAnnotation(info, retrieval, annotation, visitor.getControllerContext())) != null && !nodes.isEmpty()) {
            for (MetaDataVisitorNode node : nodes) {
                node.initialVisit(visitor);
                node.describeVisit(visitor);
            }
        }
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("@annotation=").append(this.annotation);
        buffer.append(" ,types=").append(this.types);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append("@annotation=").append(this.annotation);
    }
}

