/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.override;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.annotations.support.AnnotationTester;
import org.jboss.test.kernel.annotations.support.MyDeployer;
import org.jboss.test.kernel.annotations.test.override.AbstractAnnotationOverrideTestCase;

public class CallbackAnnotationOverrideTestCase
extends AbstractAnnotationOverrideTestCase {
    private Controller controller;
    private ControllerContext context;

    public CallbackAnnotationOverrideTestCase(String name) throws Throwable {
        super(name);
    }

    public CallbackAnnotationOverrideTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return CallbackAnnotationOverrideTestCase.suite(CallbackAnnotationOverrideTestCase.class);
    }

    protected String getType() {
        return "Callback";
    }

    protected void addMetaData(AbstractBeanMetaData beanMetaData) {
        ArrayList<InstallCallbackMetaData> installs = new ArrayList<InstallCallbackMetaData>();
        InstallCallbackMetaData in = new InstallCallbackMetaData();
        in.setMethodName("addMyDeployer");
        installs.add(in);
        ArrayList<UninstallCallbackMetaData> uninstalls = new ArrayList<UninstallCallbackMetaData>();
        UninstallCallbackMetaData un = new UninstallCallbackMetaData();
        un.setMethodName("removeMyDeployer");
        uninstalls.add(un);
        beanMetaData.setInstallCallbacks(installs);
        beanMetaData.setUninstallCallbacks(uninstalls);
    }

    public void testCallbackOverride() throws Throwable {
        AnnotationTester tester = this.getTester();
        Object val = tester.getValue();
        this.assertInstanceOf(val, Integer.class);
        Integer count = (Integer)val;
        CallbackAnnotationOverrideTestCase.assertNotNull((Object)count);
        CallbackAnnotationOverrideTestCase.assertEquals((int)1, (int)count);
        this.doUndeploy();
        val = tester.getValue();
        this.assertInstanceOf(val, Integer.class);
        count = (Integer)val;
        CallbackAnnotationOverrideTestCase.assertNotNull((Object)count);
        CallbackAnnotationOverrideTestCase.assertEquals((int)0, (int)count);
    }

    protected void afterInstall(KernelController controller, KernelControllerContext context) throws Throwable {
        controller.install((BeanMetaData)new AbstractBeanMetaData("deployer", MyDeployer.class.getName()));
        this.controller = controller;
        this.context = context;
    }

    protected void doUndeploy() {
        this.controller.uninstall((Object)"deployer");
        this.controller = null;
        this.context = null;
    }
}

