/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.NamedAliasMetaData;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class AliasTestCase
extends AbstractXMLTest {
    public AliasTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return AliasTestCase.suite(AliasTestCase.class);
    }

    protected Object getAlias(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set aliases = bean.getAliases();
        AliasTestCase.assertNotNull((Object)aliases);
        AliasTestCase.assertEquals((int)1, (int)aliases.size());
        Object alias = aliases.iterator().next();
        AliasTestCase.assertNotNull(alias);
        return alias;
    }

    public void testAlias() throws Exception {
        Object alias = this.getAlias("Alias.xml");
        AliasTestCase.assertEquals((Object)"SimpleAlias", (Object)alias);
    }

    public void testAliasWithClass() throws Exception {
        Object alias = this.getAlias("AliasWithClass.xml");
        AliasTestCase.assertEquals((Object)12345, (Object)alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAliasWithReplace() throws Exception {
        SecurityManager sm = AliasTestCase.suspendSecurity();
        try {
            System.setProperty("alias.test.name", "SimpleAlias");
            Object alias = this.getAlias("AliasWithReplace.xml");
            AliasTestCase.assertEquals((Object)"XSimpleAliasX", (Object)alias);
        }
        finally {
            AliasTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAliasWithNoReplace() throws Exception {
        SecurityManager sm = AliasTestCase.suspendSecurity();
        try {
            System.setProperty("alias.test.name", "SimpleAlias");
            Object alias = this.getAlias("AliasWithNoReplace.xml");
            AliasTestCase.assertEquals((Object)"X${alias.test.name}X", (Object)alias);
        }
        finally {
            AliasTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    public void testMultipleAliases() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean("MultipleAlias.xml");
        Set aliases = bean.getAliases();
        AliasTestCase.assertNotNull((Object)aliases);
        int size = aliases.size();
        AliasTestCase.assertTrue((size > 1 ? 1 : 0) != 0);
        for (Object alias : aliases) {
            AliasTestCase.assertNotNull(alias);
        }
    }

    public void testAliasAndBeanFactory() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean("AliasWithBeanFactory.xml");
        Set aliases = bean.getAliases();
        AliasTestCase.assertNotNull((Object)aliases);
        AliasTestCase.assertFalse((boolean)aliases.isEmpty());
    }

    protected NamedAliasMetaData getNamedAlias(String name) throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment(name);
        Set aliases = deployment.getAliases();
        AliasTestCase.assertNotNull((Object)aliases);
        AliasTestCase.assertEquals((int)1, (int)aliases.size());
        NamedAliasMetaData alias = (NamedAliasMetaData)aliases.iterator().next();
        AliasTestCase.assertNotNull((Object)alias);
        return alias;
    }

    public void testNamedAlias() throws Exception {
        NamedAliasMetaData alias = this.getNamedAlias("NamedAlias.xml");
        AliasTestCase.assertEquals((Object)"TestName", (Object)alias.getName());
        AliasTestCase.assertEquals((Object)"SimpleAlias", (Object)alias.getAliasValue());
    }

    public void testNamedAliasWithClass() throws Exception {
        NamedAliasMetaData alias = this.getNamedAlias("NamedAliasWithClass.xml");
        AliasTestCase.assertEquals((Object)"TestName", (Object)alias.getName());
        AliasTestCase.assertEquals((Object)12345, (Object)alias.getAliasValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedAliasWithReplace() throws Exception {
        SecurityManager sm = AliasTestCase.suspendSecurity();
        try {
            System.setProperty("alias.test.name", "SimpleAlias");
            NamedAliasMetaData alias = this.getNamedAlias("NamedAliasWithReplace.xml");
            AliasTestCase.assertEquals((Object)"TestName", (Object)alias.getName());
            AliasTestCase.assertEquals((Object)"XSimpleAliasX", (Object)alias.getAliasValue());
        }
        finally {
            AliasTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedAliasWithNoReplace() throws Exception {
        SecurityManager sm = AliasTestCase.suspendSecurity();
        try {
            System.setProperty("alias.test.name", "SimpleAlias");
            NamedAliasMetaData alias = this.getNamedAlias("NamedAliasWithNoReplace.xml");
            AliasTestCase.assertEquals((Object)"TestName", (Object)alias.getName());
            AliasTestCase.assertEquals((Object)"X${alias.test.name}X", (Object)alias.getAliasValue());
        }
        finally {
            AliasTestCase.resumeSecurity((SecurityManager)sm);
        }
    }
}

