/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import junit.framework.Test;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class ClassLoaderTestCase
extends AbstractXMLTest {
    protected ClassLoaderMetaData getClassLoader(String name) throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment(name);
        ClassLoaderMetaData classLoader = deployment.getClassLoader();
        ClassLoaderTestCase.assertNotNull((Object)classLoader);
        return classLoader;
    }

    public void testClassLoaderWithBean() throws Exception {
        ClassLoaderMetaData classLoader = this.getClassLoader("ClassLoaderWithBean.xml");
        ClassLoaderTestCase.assertNotNull((Object)classLoader.getClassLoader());
        ClassLoaderTestCase.assertTrue((boolean)(classLoader.getClassLoader() instanceof BeanMetaData));
    }

    public void testClassLoaderWithInject() throws Exception {
        ClassLoaderMetaData classLoader = this.getClassLoader("ClassLoaderWithInject.xml");
        this.assertInjection(classLoader.getClassLoader());
    }

    public void testClassLoaderWithNull() throws Exception {
        ClassLoaderMetaData classLoader = this.getClassLoader("ClassLoaderWithNull.xml");
        this.assertNullValue(classLoader.getClassLoader());
    }

    public void testClassLoaderWithWildcard() throws Exception {
        ClassLoaderMetaData classLoader = this.getClassLoader("ClassLoaderWithWildcard.xml");
        this.assertWildcard(classLoader.getClassLoader());
    }

    public void testClassLoaderBadNoValue() throws Exception {
        try {
            this.unmarshalDeployment("ClassLoaderBadNoValue.xml");
            ClassLoaderTestCase.fail((String)"Should not be here");
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public static Test suite() {
        return ClassLoaderTestCase.suite(ClassLoaderTestCase.class);
    }

    public ClassLoaderTestCase(String name) {
        super(name);
    }
}

