/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.api.annotations.Aliases;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.annotations.ClassAnnotationPlugin;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasesAnnotationPlugin
extends ClassAnnotationPlugin<Aliases> {
    public AliasesAnnotationPlugin() {
        super(Aliases.class);
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, Aliases annotation, KernelControllerContext context) throws Throwable {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        Set<Object> aliases = beanMetaData.getAliases();
        Controller controller = context.getController();
        for (String alias : annotation.value()) {
            if (annotation.replace()) {
                alias = StringPropertyReplacer.replaceProperties((String)alias);
            }
            if (aliases != null && aliases.contains(alias)) continue;
            if (controller.getContext((Object)(alias + "_Alias"), null) == null) {
                controller.addAlias((Object)alias, (Object)beanMetaData.getName());
                continue;
            }
            ControllerContext existingContext = controller.getContext((Object)alias, null);
            if (existingContext == null || existingContext == context) continue;
            throw new IllegalArgumentException("Alias " + alias + " already registered for different bean: " + existingContext);
        }
        return null;
    }
}

