/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.annotations.AliasesAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.kernel.plugins.annotations.AnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ArrayValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.ClassFactoryAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.CollectionValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ConstructorParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.CreateLifecycleAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.DemandsAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.DependsAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.DestroyLifecycleAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ExternalInstallAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ExternalUninstallAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.FactoryMethodAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.InjectAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.InstallMethodParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.JavaBeanValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ListValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.MapValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.MethodInstallCallbackAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.MethodUninstallCallbackAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.NullValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.PropertyAware;
import org.jboss.kernel.plugins.annotations.PropertyInstallCallbackAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.PropertyUninstallCallbackAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.SetValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.StartLifecycleAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.StopLifecycleAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.StringValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.SupplysAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ThisValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.UninstallMethodParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ValueFactoryAnnotationPlugin;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;

public class BasicBeanAnnotationAdapter
implements BeanAnnotationAdapter {
    protected Logger log = Logger.getLogger(BasicBeanAnnotationAdapter.class);
    protected Set<AnnotationPlugin> classAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> constructorAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> propertyAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> methodAnnotationPlugins = new HashSet<AnnotationPlugin>();
    protected Set<AnnotationPlugin> fieldAnnotationPlugins = new HashSet<AnnotationPlugin>();

    public BasicBeanAnnotationAdapter() {
        Annotation2ValueMetaDataAdapter[] adapters = new Annotation2ValueMetaDataAdapter[]{InjectAnnotationPlugin.INSTANCE, StringValueAnnotationPlugin.INSTANCE, ValueFactoryAnnotationPlugin.INSTANCE, ThisValueAnnotationPlugin.INSTANCE, NullValueAnnotationPlugin.INSTANCE, JavaBeanValueAnnotationPlugin.INSTANCE, CollectionValueAnnotationPlugin.INSTANCE, ListValueAnnotationPlugin.INSTANCE, SetValueAnnotationPlugin.INSTANCE, ArrayValueAnnotationPlugin.INSTANCE, MapValueAnnotationPlugin.INSTANCE};
        this.addAnnotationPlugin(new AliasesAnnotationPlugin());
        this.addAnnotationPlugin(new DemandsAnnotationPlugin());
        this.addAnnotationPlugin(new DependsAnnotationPlugin());
        this.addAnnotationPlugin(new SupplysAnnotationPlugin());
        this.addAnnotationPlugin(new ClassFactoryAnnotationPlugin(adapters));
        this.addAnnotationPlugin(new ExternalInstallAnnotationPlugin());
        this.addAnnotationPlugin(new ExternalUninstallAnnotationPlugin());
        this.addAnnotationPlugin(new ConstructorParameterAnnotationPlugin(adapters));
        this.addAnnotationPlugin(InjectAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(StringValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(ValueFactoryAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(ThisValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(NullValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(JavaBeanValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(CollectionValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(ListValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(SetValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(ArrayValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(MapValueAnnotationPlugin.INSTANCE);
        this.addAnnotationPlugin(new PropertyInstallCallbackAnnotationPlugin());
        this.addAnnotationPlugin(new PropertyUninstallCallbackAnnotationPlugin());
        this.addAnnotationPlugin(new FactoryMethodAnnotationPlugin(adapters));
        this.addAnnotationPlugin(new CreateLifecycleAnnotationPlugin(adapters));
        this.addAnnotationPlugin(new StartLifecycleAnnotationPlugin(adapters));
        this.addAnnotationPlugin(new StopLifecycleAnnotationPlugin(adapters));
        this.addAnnotationPlugin(new DestroyLifecycleAnnotationPlugin(adapters));
        this.addAnnotationPlugin(new MethodInstallCallbackAnnotationPlugin());
        this.addAnnotationPlugin(new MethodUninstallCallbackAnnotationPlugin());
        this.addAnnotationPlugin(new InstallMethodParameterAnnotationPlugin(adapters));
        this.addAnnotationPlugin(new UninstallMethodParameterAnnotationPlugin(adapters));
    }

    protected void addAnnotationPlugin(AnnotationPlugin plugin) {
        Set<ElementType> supported;
        Class annotation = plugin.getAnnotation();
        if (annotation.getAnnotation(Target.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Target annotation!"));
        }
        if (annotation.getAnnotation(Retention.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Retention annotation!"));
        }
        if ((supported = plugin.getSupportedTypes()).contains((Object)ElementType.TYPE)) {
            this.classAnnotationPlugins.add(plugin);
        }
        if (supported.contains((Object)ElementType.CONSTRUCTOR)) {
            this.constructorAnnotationPlugins.add(plugin);
        }
        if (supported.contains((Object)ElementType.METHOD)) {
            if (plugin instanceof PropertyAware) {
                this.propertyAnnotationPlugins.add(plugin);
            } else {
                this.methodAnnotationPlugins.add(plugin);
            }
        }
        if (supported.contains((Object)ElementType.FIELD)) {
            this.fieldAnnotationPlugins.add(plugin);
        }
    }

    public void applyAnnotations(MetaDataVisitor visitor) throws Throwable {
        FieldInfo[] fields;
        MethodInfo[] staticMethods;
        Set methods;
        MetaData cmdr;
        KernelControllerContext context = visitor.getControllerContext();
        Kernel kernel = context.getKernel();
        KernelMetaDataRepository repository = kernel.getMetaDataRepository();
        MetaData retrieval = repository.getMetaData(context);
        boolean trace = this.log.isTraceEnabled();
        BeanInfo info = context.getBeanInfo();
        Object name = context.getName();
        if (trace) {
            this.log.trace((Object)(name + " apply annotations"));
        }
        ClassInfo classInfo = info.getClassInfo();
        for (AnnotationPlugin plugin : this.classAnnotationPlugins) {
            plugin.applyAnnotation(classInfo, retrieval, visitor);
        }
        Set constructors = info.getConstructors();
        if (constructors != null && !constructors.isEmpty()) {
            for (ConstructorInfo ci : constructors) {
                ConstructorSignature cis = new ConstructorSignature(Configurator.getParameterTypes(trace, ci.getParameterTypes()));
                MetaData cmdr2 = retrieval.getComponentMetaData((Signature)cis);
                if (cmdr2 != null) {
                    for (AnnotationPlugin plugin : this.constructorAnnotationPlugins) {
                        plugin.applyAnnotation(ci, cmdr2, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + ci));
            }
        } else if (trace) {
            this.log.trace((Object)"No constructors");
        }
        HashSet<MethodInfo> visitedMethods = new HashSet<MethodInfo>();
        Set properties = info.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyInfo pi : properties) {
                MethodInfo setter = pi.getSetter();
                if (setter == null) continue;
                visitedMethods.add(setter);
                MethodSignature sis = new MethodSignature(setter.getName(), Configurator.getParameterTypes(trace, setter.getParameterTypes()));
                cmdr = retrieval.getComponentMetaData((Signature)sis);
                if (cmdr != null) {
                    for (AnnotationPlugin plugin : this.propertyAnnotationPlugins) {
                        plugin.applyAnnotation(pi, cmdr, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for property " + pi.getName()));
            }
        } else if (trace) {
            this.log.trace((Object)"No properties");
        }
        if ((methods = info.getMethods()) != null && !methods.isEmpty()) {
            for (MethodInfo mi : methods) {
                if (visitedMethods.contains(mi)) continue;
                MethodSignature mis = new MethodSignature(mi.getName(), Configurator.getParameterTypes(trace, mi.getParameterTypes()));
                cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    for (AnnotationPlugin plugin : this.methodAnnotationPlugins) {
                        plugin.applyAnnotation(mi, cmdr, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + mi));
            }
        } else if (trace) {
            this.log.trace((Object)"No methods");
        }
        if ((staticMethods = classInfo.getDeclaredMethods()) != null && staticMethods.length != 0) {
            for (MethodInfo smi : staticMethods) {
                if (!smi.isStatic() || !smi.isPublic()) continue;
                MethodSignature mis = new MethodSignature(smi.getName(), Configurator.getParameterTypes(trace, smi.getParameterTypes()));
                MetaData cmdr3 = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr3 != null) {
                    for (AnnotationPlugin plugin : this.methodAnnotationPlugins) {
                        plugin.applyAnnotation(smi, cmdr3, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + smi));
            }
        } else if (trace) {
            this.log.trace((Object)"No static methods");
        }
        if ((fields = classInfo.getDeclaredFields()) != null && fields.length > 0) {
            for (FieldInfo fi : fields) {
                FieldSignature fis = new FieldSignature(fi.getName());
                MetaData cmdr4 = retrieval.getComponentMetaData((Signature)fis);
                if (cmdr4 != null) {
                    for (AnnotationPlugin plugin : this.fieldAnnotationPlugins) {
                        plugin.applyAnnotation(fi, cmdr4, visitor);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for field " + fi.getName()));
            }
        } else if (trace) {
            this.log.trace((Object)"No fields");
        }
    }
}

