/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.plugins.AbstractScopeInfo;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelScopeInfo
extends AbstractScopeInfo {
    public KernelScopeInfo(Object name, String className) {
        super(name, className);
    }

    public KernelScopeInfo(Object name) {
        super(name);
    }

    public KernelScopeInfo(ScopeKey key, ScopeKey mutable) {
        super(key, mutable);
    }

    public MetaDataRetrieval initMetaDataRetrieval(MutableMetaDataRepository repository, ControllerContext context, Scope scope) {
        if (scope.getScopeLevel() == CommonLevels.CLASS) {
            if (!(context instanceof KernelControllerContext)) {
                return null;
            }
            KernelControllerContext theContext = (KernelControllerContext)context;
            BeanMetaData metaData = theContext.getBeanMetaData();
            ClassLoader cl = null;
            try {
                cl = Configurator.getClassLoader(metaData);
            }
            catch (Throwable t) {
                throw new RuntimeException("Error getting classloader for " + context.getName(), t);
            }
            try {
                Class<?> clazz = cl.loadClass(scope.getQualifier());
                return new AnnotatedElementMetaDataLoader(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load class: " + scope.getQualifier(), e);
            }
        }
        return null;
    }

    public void addMetaData(MutableMetaDataRepository repository, ControllerContext context, MemoryMetaDataLoader mutable) {
        if (!(context instanceof KernelControllerContext)) {
            return;
        }
        KernelControllerContext theContext = (KernelControllerContext)context;
        this.addClassAnnotations(mutable, theContext);
        this.addPropertyAnnotations(mutable, theContext);
    }

    private void addClassAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData != null) {
            try {
                ClassLoader cl = Configurator.getClassLoader(beanMetaData);
                this.addAnnotations(cl, mutable, beanMetaData.getAnnotations());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error getting classloader for metadata", t);
            }
        }
    }

    private void addPropertyAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        if (beanMetaData == null) {
            return;
        }
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties == null || properties.size() == 0) {
            return;
        }
        BeanInfo beanInfo = context.getBeanInfo();
        if (beanInfo == null) {
            return;
        }
        try {
            ClassLoader cl = Configurator.getClassLoader(beanMetaData);
            for (PropertyMetaData property : properties) {
                this.addPropertyAnnotations(cl, mutable, property, beanInfo);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting classloader for metadata");
        }
    }

    private void addPropertyAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, PropertyMetaData propertyMetaData, BeanInfo beanInfo) {
        Set<AnnotationMetaData> propertyAnnotations = propertyMetaData.getAnnotations();
        if (propertyAnnotations == null || propertyAnnotations.size() == 0) {
            return;
        }
        Set propertyInfos = beanInfo.getProperties();
        if (propertyInfos != null && propertyInfos.size() > 0) {
            for (PropertyInfo propertyInfo : propertyInfos) {
                if (!propertyInfo.getName().equals(propertyMetaData.getName())) continue;
                MethodInfo methodInfo = propertyInfo.getGetter();
                if (methodInfo != null) {
                    this.addAnnotations(classloader, mutable, methodInfo, propertyAnnotations);
                }
                if ((methodInfo = propertyInfo.getSetter()) == null) continue;
                this.addAnnotations(classloader, mutable, methodInfo, propertyAnnotations);
            }
        }
    }

    private void addAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, MethodInfo methodInfo, Set<AnnotationMetaData> annotations) {
        TypeInfo[] typeInfos = methodInfo.getParameterTypes();
        String[] paramTypes = new String[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            paramTypes[i] = typeInfos[i].getName();
        }
        ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, methodInfo.getName());
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(scope);
        this.addAnnotations(classloader, loader, annotations);
        mutable.addComponentMetaDataRetrieval((Signature)new MethodSignature(methodInfo.getName(), paramTypes), (MetaDataRetrieval)loader);
    }

    private void addAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, Set<AnnotationMetaData> annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        for (AnnotationMetaData annotation : annotations) {
            mutable.addAnnotation(annotation.getAnnotationInstance(classloader));
        }
    }
}

