/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.SimpleBeanFactory;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class FactoryTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return FactoryTestCase.suite(FactoryTestCase.class);
    }

    public FactoryTestCase(String name) {
        super(name);
    }

    public FactoryTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testSimpleInstantiateFromFactory() throws Throwable {
        SimpleBean bean = this.simpleInstantiateFromFactory();
        FactoryTestCase.assertEquals((String)"createSimpleBean()", (String)SimpleBeanFactory.getMethodUsed());
        FactoryTestCase.assertEquals((String)"()", (String)bean.getConstructorUsed());
    }

    protected SimpleBean simpleInstantiateFromFactory() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        SimpleBeanFactory factory = new SimpleBeanFactory();
        AbstractValueMetaData vmd = new AbstractValueMetaData((Object)factory);
        cmd.setFactory((ValueMetaData)vmd);
        cmd.setFactoryMethod("createSimpleBean");
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testSimpleInstantiateFromFactoryWithParameters() throws Throwable {
        SimpleBean bean = this.simpleInstantiateFromFactoryWithParameters();
        FactoryTestCase.assertEquals((String)"createSimpleBean(String)", (String)SimpleBeanFactory.getMethodUsed());
        FactoryTestCase.assertEquals((String)"Factory Value", (String)bean.getConstructorUsed());
    }

    protected SimpleBean simpleInstantiateFromFactoryWithParameters() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        SimpleBeanFactory factory = new SimpleBeanFactory();
        AbstractValueMetaData vmd = new AbstractValueMetaData((Object)factory);
        cmd.setFactory((ValueMetaData)vmd);
        cmd.setFactoryMethod("createSimpleBean");
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData((Object)"Factory Value");
        constructorParams.add(pmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testSimpleInstantiateFromFactoryWithIntegerParameter() throws Throwable {
        SimpleBean bean = this.simpleInstantiateFromFactoryWithIntegerParameter();
        FactoryTestCase.assertEquals((String)"createSimpleBean(integer)", (String)SimpleBeanFactory.getMethodUsed());
        FactoryTestCase.assertEquals((String)"4", (String)bean.getConstructorUsed());
    }

    protected SimpleBean simpleInstantiateFromFactoryWithIntegerParameter() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        SimpleBeanFactory factory = new SimpleBeanFactory();
        AbstractValueMetaData vmd = new AbstractValueMetaData((Object)factory);
        cmd.setFactory((ValueMetaData)vmd);
        cmd.setFactoryMethod("createSimpleBean");
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData((Object)4);
        pmd.setType("java.lang.Integer");
        constructorParams.add(pmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testStaticInstantiateFromFactory() throws Throwable {
        SimpleBean bean = this.staticInstantiateFromFactory();
        FactoryTestCase.assertEquals((String)"staticCreateSimpleBean()", (String)SimpleBeanFactory.getMethodUsed());
        FactoryTestCase.assertEquals((String)"()", (String)bean.getConstructorUsed());
    }

    protected SimpleBean staticInstantiateFromFactory() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setFactoryClass(SimpleBeanFactory.class.getName());
        cmd.setFactoryMethod("staticCreateSimpleBean");
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testStaticInstantiateFromFactoryWithParameters() throws Throwable {
        SimpleBean bean = this.staticInstantiateFromFactoryWithParameters();
        FactoryTestCase.assertEquals((String)"staticCreateSimpleBean(String)", (String)SimpleBeanFactory.getMethodUsed());
        FactoryTestCase.assertEquals((String)"Static Factory Value", (String)bean.getConstructorUsed());
    }

    protected SimpleBean staticInstantiateFromFactoryWithParameters() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setFactoryClass(SimpleBeanFactory.class.getName());
        cmd.setFactoryMethod("staticCreateSimpleBean");
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData((Object)"Static Factory Value");
        constructorParams.add(pmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }

    public void testStaticInstantiateFromFactoryWithIntegerParameter() throws Throwable {
        SimpleBean bean = this.staticInstantiateFromFactoryWithIntegerParameter();
        FactoryTestCase.assertEquals((String)"staticCreateSimpleBean(integer)", (String)SimpleBeanFactory.getMethodUsed());
        FactoryTestCase.assertEquals((String)"7", (String)bean.getConstructorUsed());
    }

    protected SimpleBean staticInstantiateFromFactoryWithIntegerParameter() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        bmd.setConstructor((ConstructorMetaData)cmd);
        cmd.setFactoryClass(SimpleBeanFactory.class.getName());
        cmd.setFactoryMethod("staticCreateSimpleBean");
        ArrayList<AbstractParameterMetaData> constructorParams = new ArrayList<AbstractParameterMetaData>();
        AbstractParameterMetaData pmd = new AbstractParameterMetaData((Object)7);
        pmd.setType("java.lang.Integer");
        constructorParams.add(pmd);
        cmd.setParameters(constructorParams);
        return (SimpleBean)this.instantiate(configurator, (BeanMetaData)bmd);
    }
}

