/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class GenericBeanFactoryDemandDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryDemandDependencyTestCase.suite(GenericBeanFactoryDemandDependencyTestCase.class);
    }

    public GenericBeanFactoryDemandDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryDemandDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testGenericBeanFactoryDemandDependencyCorrectOrder() throws Throwable {
        this.demandDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBean bean2 = (SimpleBean)factory2.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
    }

    public void demandDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryDemandDependencyWrongOrder() throws Throwable {
        this.demandDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.PRE_INSTALL);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBean bean2 = (SimpleBean)factory2.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
    }

    public void demandDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryDemandDependencyReinstall() throws Throwable {
        this.demandDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBean bean2 = (SimpleBean)factory2.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        this.assertUninstall("Name1");
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((Object)ControllerState.PRE_INSTALL, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        this.assertContext("Name2", ControllerState.PRE_INSTALL);
        context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)context1);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBean)factory2.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        this.assertUninstall("Name2");
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBean)factory2.createBean();
        GenericBeanFactoryDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
    }

    public void demandDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        GenericBeanFactoryMetaData metaData1 = new GenericBeanFactoryMetaData("Name1", SimpleBeanImpl.class.getName());
        metaData1.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("string", "String1"));
        HashSet<AbstractSupplyMetaData> supplies = new HashSet<AbstractSupplyMetaData>();
        supplies.add(new AbstractSupplyMetaData((Object)"WhatIWant"));
        metaData1.setSupplies(supplies);
        GenericBeanFactoryMetaData metaData2 = new GenericBeanFactoryMetaData("Name2", SimpleBeanImpl.class.getName());
        metaData2.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("string", "String2"));
        HashSet<AbstractDemandMetaData> demands = new HashSet<AbstractDemandMetaData>();
        demands.add(new AbstractDemandMetaData((Object)"WhatIWant"));
        metaData2.setDemands(demands);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }
}

