/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependency;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithDependencyImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class GenericBeanFactoryOnDemandDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryOnDemandDependencyTestCase.suite(GenericBeanFactoryOnDemandDependencyTestCase.class);
    }

    public GenericBeanFactoryOnDemandDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryOnDemandDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testGenericBeanFactoryOnDemandDependencyOnDemandFirst() throws Throwable {
        this.onDemandDependencyOnDemandFirst();
        ControllerContext context1 = this.assertInstall(0, "Name1", ControllerState.NOT_INSTALLED);
        ControllerContext context2 = this.assertInstall(1, "Name2");
        this.assertContext("Name1");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void onDemandDependencyOnDemandFirst() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryOnDemandDependencyOnDemandSecond() throws Throwable {
        this.onDemandDependencyOnDemandSecond();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.INSTANTIATED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void onDemandDependencyOnDemandSecond() throws Throwable {
        this.buildMetaData();
    }

    public void testGenericBeanFactoryOnDemandDependencyReinstall() throws Throwable {
        this.onDemandDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1", ControllerState.NOT_INSTALLED);
        ControllerContext context2 = this.assertInstall(1, "Name2");
        this.assertContext("Name1");
        GenericBeanFactory factory1 = (GenericBeanFactory)context1.getTarget();
        SimpleBean bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        GenericBeanFactory factory2 = (GenericBeanFactory)context2.getTarget();
        SimpleBeanWithDependency bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        this.assertUninstall("Name1");
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        context2 = this.assertContext("Name2", ControllerState.INSTANTIATED);
        context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
        this.assertUninstall("Name2");
        context1 = this.assertContext("Name1");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        factory1 = (GenericBeanFactory)context1.getTarget();
        bean1 = (SimpleBean)factory1.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean1);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        factory2 = (GenericBeanFactory)context2.getTarget();
        bean2 = (SimpleBeanWithDependency)factory2.createBean();
        GenericBeanFactoryOnDemandDependencyTestCase.assertNotNull((Object)bean2);
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        GenericBeanFactoryOnDemandDependencyTestCase.assertEquals((Object)factory1, (Object)bean2.getFactory());
    }

    public void onDemandDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        GenericBeanFactoryMetaData metaData1 = new GenericBeanFactoryMetaData("Name1", SimpleBeanImpl.class.getName());
        metaData1.setMode(ControllerMode.ON_DEMAND);
        metaData1.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("string", "String1"));
        GenericBeanFactoryMetaData metaData2 = new GenericBeanFactoryMetaData("Name2", SimpleBeanWithDependencyImpl.class.getName());
        metaData2.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("string", "String2"));
        metaData2.addBeanProperty((PropertyMetaData)new AbstractPropertyMetaData("factory", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1")));
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }
}

