/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.SimpleLifecycleBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class BeanMetaDataBuilderTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return BeanMetaDataBuilderTestCase.suite(BeanMetaDataBuilderTestCase.class);
    }

    public BeanMetaDataBuilderTestCase(String name) throws Throwable {
        super(name);
    }

    public void testConstructor() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"FromBMD", (String)SimpleBean.class.getName());
        builder.addConstructorParameter(String.class.getName(), (Object)"TestConstructor");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        SimpleBean fbmd = (SimpleBean)this.instantiateAndConfigure(beanMetaData);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)fbmd);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)fbmd.getConstructorUsed());
        BeanMetaDataBuilderTestCase.assertEquals((String)"TestConstructor", (String)fbmd.getConstructorUsed());
    }

    public void testProperty() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"PropBMD", (String)SimpleBean.class.getName()).addPropertyMetaData("adouble", (Object)3.1459).addPropertyMetaData("anint", "123").addPropertyMetaData("collection", new ArrayList());
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        SimpleBean pbmd = (SimpleBean)this.instantiateAndConfigure(beanMetaData);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)pbmd);
        this.assertEquals(3.1459, pbmd.getAdouble());
        BeanMetaDataBuilderTestCase.assertEquals((int)123, (int)pbmd.getAnint());
        BeanMetaDataBuilderTestCase.assertNotNull((Object)pbmd.getCollection());
        BeanMetaDataBuilderTestCase.assertTrue((boolean)pbmd.getCollection().isEmpty());
    }

    public void testLifecycle() throws Throwable {
        Kernel kernel = this.bootstrap();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"SLB", (String)SimpleLifecycleBean.class.getName()).addCreateParameter(String.class.getName(), (Object)"ParamCreate").setStart("doStart").addStartParameter(String.class.getName(), (Object)"ParamStart").setStop("doStop").addStopParameter(String.class.getName(), (Object)"ParamStop").addDestroyParameter(String.class.getName(), (Object)"ParamDestroy");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        KernelController controller = kernel.getController();
        KernelControllerContext context = controller.install(beanMetaData);
        SimpleLifecycleBean slb = (SimpleLifecycleBean)context.getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)slb);
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamCreate", (String)slb.getCreate());
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamStart", (String)slb.getStart());
        controller.uninstall((Object)"SLB");
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamStop", (String)slb.getStop());
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamDestroy", (String)slb.getDestroy());
    }

    public void testInstall() throws Throwable {
        Kernel kernel = this.bootstrap();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"SLB", (String)SimpleLifecycleBean.class.getName()).addInstall("installParam", String.class.getName(), (Object)"Install").addUninstall("uninstallParam", String.class.getName(), (Object)"Uninstall");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        KernelController controller = kernel.getController();
        KernelControllerContext context = controller.install(beanMetaData);
        SimpleLifecycleBean slb = (SimpleLifecycleBean)context.getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)slb);
        BeanMetaDataBuilderTestCase.assertEquals((String)"Install", (String)slb.getInstall());
        controller.uninstall((Object)"SLB");
        BeanMetaDataBuilderTestCase.assertEquals((String)"Uninstall", (String)slb.getInstall());
    }

    public void testDemandSupply() throws Throwable {
        BeanMetaDataBuilder demand = BeanMetaDataBuilderFactory.createBuilder((String)"DemandBean", (String)SimpleBean.class.getName());
        demand.addDemand((Object)"Barrier");
        BeanMetaData demandBean = demand.getBeanMetaData();
        BeanMetaDataBuilder supply = BeanMetaDataBuilderFactory.createBuilder((String)"SupplyBean", (String)SimpleLifecycleBean.class.getName());
        supply.addSupply((Object)"Barrier");
        BeanMetaData supplyBean = supply.getBeanMetaData();
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeans(Arrays.asList(demandBean, supplyBean));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        Object db = controller.getInstalledContext((Object)"DemandBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)db);
        Object sb = controller.getInstalledContext((Object)"SupplyBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)sb);
        deployer.undeploy((KernelDeployment)deployment);
    }

    public void testDependency() throws Throwable {
        BeanMetaDataBuilder dependOn = BeanMetaDataBuilderFactory.createBuilder((String)"DependOnBean", (String)SimpleBean.class.getName());
        dependOn.addDependency((Object)"DependencyResolver");
        BeanMetaData dependOnBean = dependOn.getBeanMetaData();
        BeanMetaDataBuilder resolver = BeanMetaDataBuilderFactory.createBuilder((String)"DependencyResolver", (String)SimpleLifecycleBean.class.getName());
        BeanMetaData resolverBean = resolver.getBeanMetaData();
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeans(Arrays.asList(dependOnBean, resolverBean));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        Object db = controller.getInstalledContext((Object)"DependOnBean").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)db);
        Object rb = controller.getInstalledContext((Object)"DependencyResolver").getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)rb);
        deployer.undeploy((KernelDeployment)deployment);
    }
}

