/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class ArrayTestCase
extends AbstractXMLTest {
    protected AbstractArrayMetaData getCollection(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        ArrayTestCase.assertNotNull((Object)properties);
        ArrayTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        ArrayTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        ArrayTestCase.assertNotNull((Object)property);
        ArrayTestCase.assertTrue((boolean)(value instanceof AbstractArrayMetaData));
        return (AbstractArrayMetaData)value;
    }

    public void testArray() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("Array.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
    }

    public void testArrayWithClass() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithClass.xml");
        ArrayTestCase.assertEquals((String)"CollectionClass", (String)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
    }

    public void testArrayWithElementClass() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithElementClass.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertEquals((String)"ElementClass", (String)collection.getElementType());
    }

    public void testArrayWithValue() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithValue.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertValue("Value", this.getValue(collection));
    }

    public void testArrayWithInjection() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithInjection.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertInjection(this.getValue(collection));
    }

    public void testArrayWithCollection() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithCollection.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertCollection(this.getValue(collection));
    }

    public void testArrayWithList() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithList.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertList(this.getValue(collection));
    }

    public void testArrayWithSet() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithSet.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertSet(this.getValue(collection));
    }

    public void testArrayWithArray() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithArray.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertArray(this.getValue(collection));
    }

    public void testArrayWithMap() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithMap.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertMap(this.getValue(collection));
    }

    public void testArrayWithNull() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithNull.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertNullValue(this.getValue(collection));
    }

    public void testArrayWithThis() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithThis.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertThis(this.getValue(collection));
    }

    public void testArrayWithWildcard() throws Exception {
        AbstractArrayMetaData collection = this.getCollection("ArrayWithWildcard.xml");
        ArrayTestCase.assertNull((Object)collection.getType());
        ArrayTestCase.assertNull((Object)collection.getElementType());
        this.assertWildcard(this.getValue(collection));
    }

    protected ValueMetaData getValue(AbstractArrayMetaData collection) {
        ArrayTestCase.assertEquals((int)1, (int)collection.size());
        return (ValueMetaData)collection.iterator().next();
    }

    public static Test suite() {
        return ArrayTestCase.suite(ArrayTestCase.class);
    }

    public ArrayTestCase(String name) {
        super(name);
    }
}

