/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.support.container;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPool<T> {
    private Logger log;
    private ArrayBlockingQueue<T> pool;
    private boolean poolInitialized = false;
    private BeanFactory factory;

    public BeanPool() {
        this(3);
    }

    public BeanPool(int capacity) {
        this.pool = new ArrayBlockingQueue(capacity);
    }

    public BeanFactory getFactory() {
        return this.factory;
    }

    public void setFactory(BeanFactory factory) {
        this.factory = factory;
    }

    public int size() {
        return this.pool.size();
    }

    public int remainingCapacity() {
        return this.pool.remainingCapacity();
    }

    public synchronized T createBean() throws Throwable {
        Object bean;
        if (!this.poolInitialized) {
            bean = this.factory.createBean();
            this.pool.put(bean);
            this.log = Logger.getLogger((String)("BeanPool<" + bean.getClass().getSimpleName() + ">"));
            this.log.debug((Object)("createBean, initializing pool, remainingCapacity: " + this.pool.remainingCapacity()));
            int capacity = this.pool.remainingCapacity();
            for (int n = 0; n < capacity; ++n) {
                bean = this.factory.createBean();
                this.pool.put(bean);
            }
            this.poolInitialized = true;
        }
        if ((bean = this.pool.poll(1L, TimeUnit.SECONDS)) == null) {
            throw new IllegalStateException(this + " is emtpy");
        }
        this.log.debug((Object)("End createBean, size: " + this.pool.size() + ", bean: " + bean));
        return (T)bean;
    }

    public void destroyBean(T bean) throws Throwable {
        bean = this.factory.createBean();
        this.pool.put(bean);
    }

    public void releaseBean(T bean) throws Throwable {
        this.pool.put(bean);
    }
}

