/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test;

import junit.framework.Test;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.kernel.spi.annotations.AnnotationToBeanMetaDataFactory;
import org.jboss.test.kernel.annotations.support.BeanAnnotationHolder;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class BeanAnnotationTestCase
extends AbstractKernelConfigTest {
    public BeanAnnotationTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return BeanAnnotationTestCase.suite(BeanAnnotationTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialValues() throws Throwable {
        SecurityManager sm = BeanAnnotationTestCase.suspendSecurity();
        try {
            BeanMetaData bmd = AnnotationToBeanMetaDataFactory.createBeanMetaData(BeanAnnotationHolder.class);
            BeanAnnotationTestCase.assertEquals((Object)AutowireType.CONSTRUCTOR, (Object)bmd.getAutowireType());
            BeanAnnotationTestCase.assertEquals((Object)ControllerMode.ASYNCHRONOUS, (Object)bmd.getMode());
            BeanAnnotationTestCase.assertEquals((Object)ErrorHandlingMode.MANUAL, (Object)bmd.getErrorHandlingMode());
            BeanAnnotationTestCase.assertEquals((Object)BeanAccessMode.STANDARD, (Object)bmd.getAccessMode());
        }
        finally {
            BeanAnnotationTestCase.resumeSecurity((SecurityManager)sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverriddenValues() throws Throwable {
        SecurityManager sm = BeanAnnotationTestCase.suspendSecurity();
        try {
            AbstractBeanMetaData abmd = new AbstractBeanMetaData();
            abmd.setAutowireType(AutowireType.BY_NAME);
            abmd.setMode(ControllerMode.DISABLED);
            abmd.setErrorHandlingMode(ErrorHandlingMode.DISCARD);
            abmd.setAccessMode(BeanAccessMode.FIELDS);
            BeanMetaData bmd = AnnotationToBeanMetaDataFactory.fillBeanMetaData(BeanAnnotationHolder.class, (BeanAccessMode)BeanAccessMode.FIELDS, (BeanMetaData)abmd);
            BeanAnnotationTestCase.assertEquals((Object)AutowireType.BY_NAME, (Object)bmd.getAutowireType());
            BeanAnnotationTestCase.assertEquals((Object)ControllerMode.DISABLED, (Object)bmd.getMode());
            BeanAnnotationTestCase.assertEquals((Object)ErrorHandlingMode.DISCARD, (Object)bmd.getErrorHandlingMode());
            BeanAnnotationTestCase.assertEquals((Object)BeanAccessMode.FIELDS, (Object)bmd.getAccessMode());
        }
        finally {
            BeanAnnotationTestCase.resumeSecurity((SecurityManager)sm);
        }
    }
}

