/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.factory;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.kernel.spi.annotations.AnnotationToBeanMetaDataFactory;
import org.jboss.kernel.spi.annotations.BeanMetaDataAnnotationAdapter;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.BaseTestCase;
import org.jboss.test.kernel.annotations.support.AliasesImpl;
import org.jboss.test.kernel.annotations.support.AllIoCAnnotations;
import org.jboss.test.kernel.annotations.support.AnnotationTester;
import org.jboss.test.kernel.annotations.support.ConstructorAnnotationTester;
import org.jboss.test.kernel.annotations.support.SimpleBeanMetaDataAnnotationAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationToBeanMetaDataFactoryTestCase
extends BaseTestCase {
    public AnnotationToBeanMetaDataFactoryTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return AnnotationToBeanMetaDataFactoryTestCase.suite(AnnotationToBeanMetaDataFactoryTestCase.class);
    }

    protected void testInstalls(List<InstallMetaData> installs) {
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull(installs);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((int)2, (int)installs.size());
        for (InstallMetaData imd : installs) {
            String bean = imd.getBean();
            if (bean == null) {
                AnnotationToBeanMetaDataFactoryTestCase.assertEquals((String)"invoke", (String)imd.getMethodName());
                continue;
            }
            AnnotationToBeanMetaDataFactoryTestCase.assertEquals((Object)"bean", (Object)bean);
            AnnotationToBeanMetaDataFactoryTestCase.assertEquals((String)"method", (String)imd.getMethodName());
        }
    }

    protected void testLifecycle(LifecycleMetaData lifecycle, String method) {
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)lifecycle);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((String)method, (String)lifecycle.getMethodName());
    }

    protected void testBMD(BeanMetaData bmd) throws Throwable {
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)bmd);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals(Collections.singleton("alias"), (Object)bmd.getAliases());
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals(Collections.singleton(new AbstractSupplyMetaData((Object)"supply")), (Object)bmd.getSupplies());
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals(Collections.singleton(new AbstractDemandMetaData((Object)"demand")), (Object)bmd.getDemands());
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals(Collections.singleton(new AbstractDependencyMetaData((Object)"depend")), (Object)bmd.getDepends());
        ConstructorMetaData cmd = bmd.getConstructor();
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)cmd);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((String)AnnotationTester.class.getName(), (String)cmd.getFactoryClass());
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((String)"factoryMethod", (String)cmd.getFactoryMethod());
        this.testInstalls(bmd.getInstalls());
        this.testInstalls(bmd.getUninstalls());
        List callbacks = bmd.getInstallCallbacks();
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)callbacks);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((int)1, (int)callbacks.size());
        CallbackMetaData callback = (CallbackMetaData)callbacks.get(0);
        AnnotationToBeanMetaDataFactoryTestCase.assertTrue((boolean)callback.getMethodName().contains("Something"));
        callbacks = bmd.getUninstallCallbacks();
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)callbacks);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((int)1, (int)callbacks.size());
        callback = (CallbackMetaData)callbacks.get(0);
        AnnotationToBeanMetaDataFactoryTestCase.assertTrue((boolean)callback.getMethodName().contains("Something"));
        BeanAccessMode mode = bmd.getAccessMode();
        if (mode == BeanAccessMode.ALL) {
            Set propertys = bmd.getProperties();
            AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)propertys);
            AnnotationToBeanMetaDataFactoryTestCase.assertEquals((int)2, (int)propertys.size());
        } else {
            Set propertys = bmd.getProperties();
            AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)propertys);
            AnnotationToBeanMetaDataFactoryTestCase.assertEquals((int)1, (int)propertys.size());
            PropertyMetaData pmd = (PropertyMetaData)propertys.iterator().next();
            AnnotationToBeanMetaDataFactoryTestCase.assertEquals((String)"number", (String)pmd.getName());
            this.assertInstanceOf(pmd.getValue(), AbstractDependencyValueMetaData.class);
        }
        this.testLifecycle(bmd.getCreate(), "myCreate");
        this.testLifecycle(bmd.getStart(), "myStart");
        this.testLifecycle(bmd.getStop(), "myStop");
        this.testLifecycle(bmd.getDestroy(), "myDestroy");
    }

    public void testDefaultAnnotation2BMDFactory() throws Throwable {
        BeanMetaData bmd1 = AnnotationToBeanMetaDataFactory.createBeanMetaData(AllIoCAnnotations.class);
        this.testBMD(bmd1);
        bmd1 = AnnotationToBeanMetaDataFactory.createBeanMetaData(AllIoCAnnotations.class, (BeanAccessMode)BeanAccessMode.ALL);
        this.testBMD(bmd1);
        bmd1 = AnnotationToBeanMetaDataFactory.createBeanMetaData(ConstructorAnnotationTester.class);
        ConstructorMetaData cmd = bmd1.getConstructor();
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)cmd);
        List parameters = cmd.getParameters();
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)parameters);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((int)1, (int)parameters.size());
    }

    public void testProvidedMetaData() throws Throwable {
        MemoryMetaDataLoader memory = new MemoryMetaDataLoader(new ScopeKey(CommonLevels.INSTANCE, (Object)"foobar"));
        memory.addAnnotation((Annotation)((Object)new AliasesImpl("alias")));
        AbstractMetaDataContext retrieval = new AbstractMetaDataContext(null, (MetaDataRetrieval)memory);
        MetaDataRetrievalToMetaDataBridge metaData = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)retrieval);
        BeanMetaData bmd = AnnotationToBeanMetaDataFactory.createBeanMetaData(Object.class, (MetaData)metaData);
        AnnotationToBeanMetaDataFactoryTestCase.assertNotNull((Object)bmd);
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals(Collections.singleton("alias"), (Object)bmd.getAliases());
    }

    public void testCustomAdapter() throws Throwable {
        BeanMetaData bmd = AnnotationToBeanMetaDataFactory.createBeanMetaData(Object.class, (BeanMetaDataAnnotationAdapter)new SimpleBeanMetaDataAnnotationAdapter());
        AnnotationToBeanMetaDataFactoryTestCase.assertEquals((Object)ControllerMode.ASYNCHRONOUS, (Object)bmd.getMode());
    }

    public void testIllegalAccessMode() throws Throwable {
        AbstractBeanMetaData abmd = new AbstractBeanMetaData();
        abmd.setAccessMode(BeanAccessMode.FIELDS);
        try {
            AnnotationToBeanMetaDataFactory.fillBeanMetaData(Object.class, (BeanAccessMode)BeanAccessMode.ALL, (BeanMetaData)abmd);
            AnnotationToBeanMetaDataFactoryTestCase.fail((String)"Should not be here.");
        }
        catch (Throwable t) {
            this.assertInstanceOf(t, IllegalArgumentException.class);
        }
    }
}

