/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.override;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.annotations.support.MyDeployer;
import org.jboss.test.kernel.annotations.test.override.AbstractAnnotationOverrideTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetsAnnotationOverrideTestCase
extends AbstractAnnotationOverrideTestCase {
    private KernelControllerContext context;

    public SetsAnnotationOverrideTestCase(String name) throws Throwable {
        super(name);
    }

    public SetsAnnotationOverrideTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return SetsAnnotationOverrideTestCase.suite(SetsAnnotationOverrideTestCase.class);
    }

    @Override
    protected String getType() {
        return "Sets";
    }

    @Override
    protected void addMetaData(AbstractBeanMetaData beanMetaData) {
        Set<AbstractDemandMetaData> demands = Collections.singleton(new AbstractDemandMetaData((Object)"deployer"));
        beanMetaData.setDemands(new HashSet<AbstractDemandMetaData>(demands));
        Set<AbstractDependencyMetaData> depends = Collections.singleton(new AbstractDependencyMetaData((Object)"deployer"));
        beanMetaData.setDepends(new HashSet<AbstractDependencyMetaData>(depends));
        Set<AbstractSupplyMetaData> supplys = Collections.singleton(new AbstractSupplyMetaData((Object)"somesupply"));
        beanMetaData.setSupplies(new HashSet<AbstractSupplyMetaData>(supplys));
    }

    public void testSetsOverride() throws Throwable {
        this.getTester();
        BeanMetaData beanMetaData = this.getBeanMetaData();
        this.assertSet(beanMetaData.getDemands());
        this.assertSet(beanMetaData.getDepends());
        this.assertSet(beanMetaData.getSupplies());
    }

    protected BeanMetaData getBeanMetaData() {
        return this.context.getBeanMetaData();
    }

    protected void assertSet(Set<?> set) {
        SetsAnnotationOverrideTestCase.assertNotNull(set);
        SetsAnnotationOverrideTestCase.assertEquals((int)1, (int)set.size());
    }

    @Override
    protected void afterInstall(KernelController controller, KernelControllerContext context) throws Throwable {
        controller.install((BeanMetaData)new AbstractBeanMetaData("deployer", MyDeployer.class.getName()));
        this.context = context;
    }
}

