/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.test.kernel.config.support.MyBeanFactory;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.SimpleBeanFactory;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class GenericFactoryInstantiateTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return GenericFactoryInstantiateTestCase.suite(GenericFactoryInstantiateTestCase.class);
    }

    public GenericFactoryInstantiateTestCase(String name) {
        super(name);
    }

    public GenericFactoryInstantiateTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    protected void assertFactory(BeanFactory factory) throws Throwable {
        GenericFactoryInstantiateTestCase.assertNotNull((Object)factory);
        SimpleBean bean1 = (SimpleBean)factory.createBean();
        GenericFactoryInstantiateTestCase.assertNotNull((Object)bean1);
        GenericFactoryInstantiateTestCase.assertEquals((int)123, (int)bean1.getAnint());
        SimpleBean bean2 = (SimpleBean)factory.createBean();
        GenericFactoryInstantiateTestCase.assertNotNull((Object)bean2);
        GenericFactoryInstantiateTestCase.assertEquals((int)123, (int)bean2.getAnint());
    }

    public void testBeanFactoryFromBean() throws Throwable {
        BeanFactory factory = this.configureFromBean();
        this.assertFactory(factory);
    }

    protected BeanFactory configureFromBean() throws Throwable {
        GenericBeanFactoryMetaData factory = new GenericBeanFactoryMetaData("Factory", SimpleBean.class.getName());
        this.addBeanProperty(factory, (PropertyMetaData)new AbstractPropertyMetaData("anint", (Object)123));
        return this.instantiate(factory);
    }

    public void testBeanFactoryFromFactory() throws Throwable {
        BeanFactory factory = this.configureFromFactory();
        this.assertFactory(factory);
    }

    protected BeanFactory configureFromFactory() throws Throwable {
        GenericBeanFactoryMetaData factory = new GenericBeanFactoryMetaData();
        factory.setName("Factory");
        AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
        factory.setConstructor((ConstructorMetaData)constructor);
        constructor.setFactory((ValueMetaData)new AbstractValueMetaData((Object)new SimpleBeanFactory()));
        constructor.setFactoryMethod("createSimpleBean");
        this.addBeanProperty(factory, (PropertyMetaData)new AbstractPropertyMetaData("anint", (Object)123));
        return this.instantiate(factory);
    }

    public void testBeanFactoryFromStaticFactory() throws Throwable {
        BeanFactory factory = this.configureFromStaticFactory();
        this.assertFactory(factory);
    }

    protected BeanFactory configureFromStaticFactory() throws Throwable {
        GenericBeanFactoryMetaData factory = new GenericBeanFactoryMetaData();
        factory.setName("Factory");
        AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
        factory.setConstructor((ConstructorMetaData)constructor);
        constructor.setFactoryClass(SimpleBeanFactory.class.getName());
        constructor.setFactoryMethod("staticCreateSimpleBean");
        this.addBeanProperty(factory, (PropertyMetaData)new AbstractPropertyMetaData("anint", (Object)123));
        return this.instantiate(factory);
    }

    public void testBeanFactoryWithNonExistingClass() throws Throwable {
        BeanFactory factory = this.configureFromIllegalClass();
        GenericFactoryInstantiateTestCase.assertNotNull((Object)factory);
        try {
            factory.createBean();
        }
        catch (Exception ex) {
            this.assertInstanceOf(ex, ClassNotFoundException.class);
        }
    }

    protected BeanFactory configureFromIllegalClass() throws Throwable {
        GenericBeanFactoryMetaData factory = new GenericBeanFactoryMetaData("Factory", "org.jboss.test.NoSuchClass");
        return this.instantiate(factory);
    }

    public void testBeanFactoryDefinedFactoryClass() throws Throwable {
        BeanFactory factory = this.configureFromDefinedFactoryClass();
        GenericFactoryInstantiateTestCase.assertNotNull((Object)factory);
        this.assertInstanceOf(factory, MyBeanFactory.class);
        GenericFactoryInstantiateTestCase.assertEquals((Object)"foobar", (Object)factory.createBean());
    }

    protected BeanFactory configureFromDefinedFactoryClass() throws Throwable {
        GenericBeanFactoryMetaData factory = new GenericBeanFactoryMetaData("Factory", SimpleBean.class.getName());
        factory.setFactoryClass(MyBeanFactory.class.getName());
        return this.instantiate(factory);
    }

    protected BeanFactory instantiate(GenericBeanFactoryMetaData factory) throws Throwable {
        List beans = factory.getBeans();
        GenericFactoryInstantiateTestCase.assertNotNull((Object)beans);
        GenericFactoryInstantiateTestCase.assertEquals((int)1, (int)beans.size());
        return (BeanFactory)this.instantiate((BeanMetaData)beans.get(0));
    }

    protected void addBeanProperty(GenericBeanFactoryMetaData factory, PropertyMetaData property) {
        HashSet<PropertyMetaData> propertys = factory.getProperties();
        if (propertys == null) {
            propertys = new HashSet<PropertyMetaData>();
            factory.setProperties(propertys);
        }
        propertys.add(property);
    }
}

