/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTrimTestCase
extends AbstractKernelConfigTest {
    public ValueTrimTestCase(String name) {
        super(name);
    }

    public ValueTrimTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public static Test suite() {
        return ValueTrimTestCase.suite(ValueTrimTestCase.class);
    }

    protected Object getValue(boolean trim, String value, Class<?> clazz) throws Throwable {
        Kernel kernel = this.bootstrap();
        StringValueMetaData string = new StringValueMetaData(value);
        string.setTrim(trim);
        KernelConfigurator configurator = kernel.getConfigurator();
        string.setConfigurator(configurator);
        return string.getValue((TypeInfo)configurator.getClassInfo(clazz), Thread.currentThread().getContextClassLoader());
    }

    protected Object getTrimmedValue() throws Throwable {
        return this.getValue(true, " 10 ", Integer.class);
    }

    public void testValueTrim() throws Throwable {
        Object value = this.getTrimmedValue();
        ValueTrimTestCase.assertNotNull((Object)value);
        this.assertInstanceOf(value, Integer.class);
        ValueTrimTestCase.assertEquals((Object)10, (Object)value);
    }

    protected Object getPlainValue() throws Throwable {
        return this.getValue(false, " 10 ", Integer.class);
    }

    protected Class<? extends Exception> getExceptionClass() {
        return NumberFormatException.class;
    }

    public void testValueNoTrim() throws Throwable {
        try {
            Object value = this.getPlainValue();
            ValueTrimTestCase.assertNull((String)"Should not be here.", (Object)value);
        }
        catch (Throwable t) {
            this.assertInstanceOf(t, this.getExceptionClass());
        }
    }
}

