/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.controller.test;

import junit.framework.Test;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.controller.support.TestBean;
import org.jboss.test.kernel.controller.support.TestBeanRepository;
import org.jboss.test.kernel.controller.test.AbstractControllerTest;

public class InstallWhenRequiredErrorTestCase
extends AbstractControllerTest {
    public static Test suite() {
        return InstallWhenRequiredErrorTestCase.suite(InstallWhenRequiredErrorTestCase.class);
    }

    public InstallWhenRequiredErrorTestCase(String name) throws Throwable {
        super(name);
    }

    protected ControllerState[] getStates() {
        return new ControllerState[]{ControllerState.CONFIGURED, ControllerState.CREATE, ControllerState.START};
    }

    protected BeanMetaData createBeanMetaData(ControllerState state) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"Bean", (String)TestBean.class.getName());
        builder.addInstallWithThis("add", "Repository1", null, state);
        builder.addInstallWithThis("add", "Repository2", null, state);
        builder.addUninstallWithThis("remove", "Repository1", null, state);
        builder.addUninstallWithThis("remove", "Repository2", null, state);
        return builder.getBeanMetaData();
    }

    public void testErrorInInstallWithSupplies() throws Throwable {
        ControllerState[] states;
        for (ControllerState state : states = this.getStates()) {
            this.runErrorInInstallWithSupplies(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runErrorInInstallWithSupplies(ControllerState state) throws Throwable {
        KernelDeployment repository = this.deploy("InstallErrorTestCase_Repositories.xml");
        try {
            BeanMetaData metaData = this.createBeanMetaData(state);
            KernelControllerContext deployment = this.deploy(metaData);
            try {
                KernelControllerContext context = this.getControllerContext("Bean", null);
                InstallWhenRequiredErrorTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context.getState());
                InstallWhenRequiredErrorTestCase.checkThrowable(Error.class, (Throwable)context.getError());
                try {
                    this.getControllerContext("TestSupply", null);
                    InstallWhenRequiredErrorTestCase.fail((String)"Should not be here!");
                }
                catch (Throwable throwable) {
                    InstallWhenRequiredErrorTestCase.checkThrowable(IllegalStateException.class, (Throwable)throwable);
                }
            }
            finally {
                this.undeploy(deployment);
            }
        }
        finally {
            this.undeploy(repository);
        }
    }

    public void testErrorInInstallRedeploy() throws Throwable {
        ControllerState[] states;
        for (ControllerState state : states = this.getStates()) {
            this.runErrorInInstallRedeploy(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runErrorInInstallRedeploy(ControllerState state) throws Throwable {
        KernelDeployment repository = this.deploy("InstallErrorTestCase_Repositories.xml");
        try {
            BeanMetaData metaData = this.createBeanMetaData(state);
            KernelControllerContext kcc = this.deploy(metaData);
            try {
                KernelControllerContext context = this.getControllerContext("Bean", null);
                InstallWhenRequiredErrorTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context.getState());
                InstallWhenRequiredErrorTestCase.checkThrowable(Error.class, (Throwable)context.getError());
            }
            finally {
                this.undeploy(kcc);
            }
            KernelDeployment deployment = this.deploy("InstallErrorTestCase_BeanNoInstall.xml");
            try {
                InstallWhenRequiredErrorTestCase.assertNotNull((Object)this.getControllerContext("Bean"));
            }
            finally {
                this.undeploy(deployment);
            }
        }
        finally {
            this.undeploy(repository);
        }
    }

    public void testErrorInInstall() throws Throwable {
        ControllerState[] states;
        for (ControllerState state : states = this.getStates()) {
            this.runErrorInInstall(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runErrorInInstall(ControllerState state) throws Throwable {
        KernelDeployment repository = this.deploy("InstallErrorTestCase_Repositories.xml");
        try {
            TestBeanRepository repository1 = (TestBeanRepository)this.getBean("Repository1");
            TestBeanRepository repository2 = (TestBeanRepository)this.getBean("Repository2");
            BeanMetaData metaData = this.createBeanMetaData(state);
            KernelControllerContext deployment = this.deploy(metaData);
            try {
                KernelControllerContext context = this.getControllerContext("Bean", null);
                InstallWhenRequiredErrorTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context.getState());
                InstallWhenRequiredErrorTestCase.checkThrowable(Error.class, (Throwable)context.getError());
                this.assertEmpty(repository1.getBeans());
                this.assertEmpty(repository2.getBeans());
            }
            finally {
                this.undeploy(deployment);
            }
        }
        finally {
            this.undeploy(repository);
        }
    }
}

