/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.dependency.support.TestUtil;

public class AbstractKernelDependencyTest
extends AbstractKernelTest {
    private TestUtil util;
    private boolean xmltest;
    private BeanMetaData[] beanMetaDatas;

    public AbstractKernelDependencyTest(String name) throws Throwable {
        this(name, false);
    }

    public AbstractKernelDependencyTest(String name, boolean xmltest) throws Throwable {
        super(name);
        this.xmltest = xmltest;
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            Kernel kernel = this.bootstrap();
            this.util = new TestUtil(kernel, this);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected TestUtil getUtil() {
        return this.util;
    }

    protected ControllerContext install(int number, String name) throws Throwable {
        if (this.xmltest) {
            this.deploy(number);
            return this.util.getContext(name);
        }
        return this.util.install(this.beanMetaDatas[number]);
    }

    protected void uninstall(String name) throws Throwable {
        this.util.uninstall(name);
    }

    protected ControllerContext assertInstall(int number, String name) throws Throwable {
        return this.assertInstall(number, name, ControllerState.INSTALLED);
    }

    protected ControllerContext assertInstall(int number, String name, ControllerState expected) throws Throwable {
        ControllerContext context = this.install(number, name);
        AbstractKernelDependencyTest.assertNotNull((String)("Missing context with name: " + name), (Object)context);
        AbstractKernelDependencyTest.assertEquals((Object)expected, (Object)context.getState());
        return context;
    }

    protected ControllerContext assertContext(String name) throws Throwable {
        return this.assertContext(name, ControllerState.INSTALLED);
    }

    protected ControllerContext assertContext(String name, ControllerState expected) throws Throwable {
        ControllerContext context = this.util.getContext(name);
        AbstractKernelDependencyTest.assertNotNull((String)("Expected " + name + " state=" + expected.toShortString()), (Object)context);
        AbstractKernelDependencyTest.assertEquals((Object)expected, (Object)context.getState());
        return context;
    }

    protected void assertUninstall(String name) throws Throwable {
        this.uninstall(name);
        this.assertNotInstalled(name);
        ControllerContext context = this.util.getContext(name);
        AbstractKernelDependencyTest.assertNull((Object)context);
    }

    protected void assertNotInstalled(String name) throws Throwable {
        if (this.util.getInstalledContext(name) != null) {
            AbstractKernelDependencyTest.fail((String)"Should not be installed");
        }
    }

    protected void setBeanMetaDatas(BeanMetaData[] beanMetaDatas) {
        if (this.xmltest) {
            return;
        }
        this.beanMetaDatas = beanMetaDatas;
    }

    protected void addBeanProperty(GenericBeanFactoryMetaData factory, PropertyMetaData property) {
        HashSet<PropertyMetaData> propertys = factory.getProperties();
        if (propertys == null) {
            propertys = new HashSet<PropertyMetaData>();
            factory.setProperties(propertys);
        }
        propertys.add(property);
    }

    protected BeanMetaData getBeanMetaData(GenericBeanFactoryMetaData factory) {
        List beans = factory.getBeans();
        AbstractKernelDependencyTest.assertNotNull((Object)beans);
        AbstractKernelDependencyTest.assertEquals((int)1, (int)beans.size());
        return (BeanMetaData)beans.get(0);
    }

    protected void deploy(int number) throws Throwable {
        String name = ((Object)((Object)this)).getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            name = name.substring(dot + 1);
        }
        name = name + number + ".xml";
        this.getLog().debug((Object)("Using " + name));
        URL url = this.getResource(name);
        if (url == null) {
            throw new RuntimeException("Resource not found: " + name);
        }
        this.getLog().debug((Object)("url=" + url));
        this.util.deploy(url);
    }

    protected void configureLoggingAfterBootstrap() {
    }
}

