/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.GenericBeanFactoryRepositoryBF;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.test.AbstractKernelDependencyTest;

public class GenericBeanFactoryCallbackDependencyTestCase
extends AbstractKernelDependencyTest {
    public static Test suite() {
        return GenericBeanFactoryCallbackDependencyTestCase.suite(GenericBeanFactoryCallbackDependencyTestCase.class);
    }

    public GenericBeanFactoryCallbackDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public GenericBeanFactoryCallbackDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testInstallDependencyCorrectOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactoryRepositoryBF bean1 = (GenericBeanFactoryRepositoryBF)((Object)context1.getTarget());
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)((Object)bean1));
        SimpleBeanImpl bean2 = (SimpleBeanImpl)context2.getTarget();
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<SimpleBeanImpl> expected = new ArrayList<SimpleBeanImpl>();
        expected.add(bean2);
        GenericBeanFactoryCallbackDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    public void testInstallDependencyWrongOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context2 = this.assertInstall(1, "Name2");
        ControllerContext context1 = this.assertInstall(0, "Name1");
        GenericBeanFactoryRepositoryBF bean1 = (GenericBeanFactoryRepositoryBF)((Object)context1.getTarget());
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)((Object)bean1));
        SimpleBeanImpl bean2 = (SimpleBeanImpl)context2.getTarget();
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<SimpleBeanImpl> expected = new ArrayList<SimpleBeanImpl>();
        expected.add(bean2);
        GenericBeanFactoryCallbackDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    public void testInstallDependencyReinstall() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        GenericBeanFactoryRepositoryBF bean1 = (GenericBeanFactoryRepositoryBF)((Object)context1.getTarget());
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)((Object)bean1));
        SimpleBeanImpl bean2 = (SimpleBeanImpl)context2.getTarget();
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)bean2);
        ArrayList<SimpleBeanImpl> expected = new ArrayList<SimpleBeanImpl>();
        expected.add(bean2);
        GenericBeanFactoryCallbackDependencyTestCase.assertEquals(expected, bean1.getBeans());
        this.assertUninstall("Name1");
        this.assertContext("Name2");
        expected = new ArrayList();
        GenericBeanFactoryCallbackDependencyTestCase.assertEquals(expected, bean1.getBeans());
        context1 = this.assertInstall(0, "Name1");
        this.assertContext("Name2", ControllerState.INSTALLED);
        bean1 = (GenericBeanFactoryRepositoryBF)((Object)context1.getTarget());
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)((Object)bean1));
        expected = new ArrayList();
        expected.add(bean2);
        GenericBeanFactoryCallbackDependencyTestCase.assertEquals(expected, bean1.getBeans());
        this.assertUninstall("Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        expected = new ArrayList();
        GenericBeanFactoryCallbackDependencyTestCase.assertEquals(expected, bean1.getBeans());
        context2 = this.assertInstall(1, "Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        bean2 = (SimpleBeanImpl)context2.getTarget();
        GenericBeanFactoryCallbackDependencyTestCase.assertNotNull((Object)bean2);
        expected = new ArrayList();
        expected.add(bean2);
        GenericBeanFactoryCallbackDependencyTestCase.assertEquals(expected, bean1.getBeans());
    }

    protected void setupBeanMetaDatas() throws Throwable {
        GenericBeanFactoryMetaData metaData1 = new GenericBeanFactoryMetaData("Name1", SimpleBeanImpl.class.getName());
        metaData1.setFactoryClass(GenericBeanFactoryRepositoryBF.class.getName());
        ArrayList<InstallCallbackMetaData> installs = new ArrayList<InstallCallbackMetaData>();
        InstallCallbackMetaData install = new InstallCallbackMetaData();
        install.setMethodName("addGenericBeanFactory");
        installs.add(install);
        metaData1.setInstallCallbacks(installs);
        ArrayList<UninstallCallbackMetaData> uninstalls = new ArrayList<UninstallCallbackMetaData>();
        UninstallCallbackMetaData uninstall = new UninstallCallbackMetaData();
        uninstall.setMethodName("removeGenericBeanFactory");
        uninstalls.add(uninstall);
        metaData1.setUninstallCallbacks(uninstalls);
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("Name2", SimpleBeanImpl.class.getName());
        this.setBeanMetaDatas(new BeanMetaData[]{this.getBeanMetaData(metaData1), metaData2});
    }
}

