/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import junit.framework.Test;
import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanDelegate;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class OptionalTestCase
extends OldAbstractKernelDependencyTest {
    public OptionalTestCase(String name) throws Throwable {
        super(name);
    }

    public OptionalTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public static Test suite() {
        return OptionalTestCase.suite(OptionalTestCase.class);
    }

    public void testOptionalCorrectOrder() throws Throwable {
        this.optionalCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        SimpleBeanDelegate repository = (SimpleBeanDelegate)context1.getTarget();
        OptionalTestCase.assertNotNull((Object)repository);
        OptionalTestCase.assertNull((Object)repository.getDelegate());
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean = (SimpleBean)context2.getTarget();
        OptionalTestCase.assertNotNull((Object)bean);
        OptionalTestCase.assertNull((Object)repository.getDelegate());
    }

    protected void optionalCorrectOrder() throws Throwable {
        this.buildMetaData((BeanMetaData)this.buildRepository());
    }

    public void testOptionalWrongOrder() throws Throwable {
        this.optionalWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean = (SimpleBean)context2.getTarget();
        OptionalTestCase.assertNotNull((Object)bean);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        SimpleBeanDelegate repository = (SimpleBeanDelegate)context1.getTarget();
        OptionalTestCase.assertNotNull((Object)repository);
        OptionalTestCase.assertSame((Object)bean, (Object)repository.getDelegate());
    }

    protected void optionalWrongOrder() throws Throwable {
        this.buildMetaData((BeanMetaData)this.buildRepository());
    }

    public void testOptionalReinstall() throws Throwable {
        this.optionalReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        SimpleBeanDelegate repository = (SimpleBeanDelegate)context1.getTarget();
        OptionalTestCase.assertNotNull((Object)repository);
        OptionalTestCase.assertNull((Object)repository.getDelegate());
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean = (SimpleBean)context2.getTarget();
        OptionalTestCase.assertNotNull((Object)bean);
        OptionalTestCase.assertNull((Object)repository.getDelegate());
        this.assertUninstall("Name1");
        OptionalTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        context1 = this.assertInstall(0, "Name1");
        repository = (SimpleBeanDelegate)context1.getTarget();
        OptionalTestCase.assertNotNull((Object)repository);
        OptionalTestCase.assertSame((Object)bean, (Object)repository.getDelegate());
        this.assertUninstall("Name2");
        OptionalTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        OptionalTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context1.getState());
        OptionalTestCase.assertNull((Object)repository.getDelegate());
    }

    protected void optionalReinstall() throws Throwable {
        this.buildMetaData((BeanMetaData)this.buildRepository());
    }

    protected void buildMetaData(BeanMetaData repository) {
        this.setBeanMetaDatas(new BeanMetaData[]{repository, new AbstractBeanMetaData("Name2", SimpleBeanImpl.class.getName())});
    }

    protected AbstractBeanMetaData buildRepository() {
        AbstractBeanMetaData repository = new AbstractBeanMetaData("Name1", SimpleBeanDelegate.class.getName());
        AbstractInjectionValueMetaData vmd = new AbstractInjectionValueMetaData((Object)"Name2");
        vmd.setInjectionOption(InjectOption.OPTIONAL);
        repository.addProperty((PropertyMetaData)new AbstractPropertyMetaData("delegate", (ValueMetaData)vmd));
        return repository;
    }
}

