/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.support.SimplerBean;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class PropertyDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return PropertyDependencyTestCase.suite(PropertyDependencyTestCase.class);
    }

    public PropertyDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public PropertyDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testPropertyDependencyCorrectOrder() throws Throwable {
        this.propertyDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimplerBean bean1 = (SimplerBean)context1.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean1);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimplerBean bean2 = (SimplerBean)context2.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean2);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
    }

    public void propertyDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testPropertyDependencyWrongOrder() throws Throwable {
        this.propertyDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.INSTANTIATED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        PropertyDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        SimplerBean bean1 = (SimplerBean)context1.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean1);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimplerBean bean2 = (SimplerBean)context2.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean2);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
    }

    public void propertyDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testPropertyDependencyReinstall() throws Throwable {
        this.propertyDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimplerBean bean1 = (SimplerBean)context1.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean1);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimplerBean bean2 = (SimplerBean)context2.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean2);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
        this.assertUninstall("Name1");
        PropertyDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        PropertyDependencyTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context2.getState());
        this.assertNotInstalled("Name2");
        context2 = this.assertContext("Name2", ControllerState.INSTANTIATED);
        context1 = this.assertInstall(0, "Name1");
        PropertyDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        bean1 = (SimplerBean)context1.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean1);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimplerBean)context2.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean2);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
        this.assertUninstall("Name2");
        context1 = this.assertContext("Name1");
        bean1 = (SimplerBean)context1.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean1);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        bean1 = (SimplerBean)context1.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean1);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimplerBean)context2.getTarget();
        PropertyDependencyTestCase.assertNotNull((Object)bean2);
        PropertyDependencyTestCase.assertEquals((String)"String1", (String)bean2.getString());
    }

    public void propertyDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = this.createName1();
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        AbstractBeanMetaData metaData2 = this.createName2();
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("string", (ValueMetaData)new AbstractDependencyValueMetaData((Object)"Name1", "string")));
        metaData2.setProperties(attributes2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }

    protected AbstractBeanMetaData createName1() {
        return new AbstractBeanMetaData("Name1", SimpleBeanImpl.class.getName());
    }

    protected AbstractBeanMetaData createName2() {
        return new AbstractBeanMetaData("Name2", SimpleBeanImpl.class.getName());
    }
}

