/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.net.URL;
import java.util.Collection;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.kernel.deployment.xml.test.DebugElementHandler;
import org.jboss.test.kernel.deployment.xml.test.JBossXBTestDelegate;
import org.jboss.util.UnreachableStatementException;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBuilderTest
extends AbstractTestCaseWithSetup {
    protected String rootName = this.getRootName();
    private static final DebugElementHandler DEBUG_ELEMENT_HANDLER = new DebugElementHandler();
    private ParticleHandler elementHandler;
    private ParticleHandler simpleHandler;

    public AbstractBuilderTest(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new JBossXBTestDelegate(clazz);
    }

    protected JBossXBTestDelegate getJBossXBDelegate() {
        return (JBossXBTestDelegate)this.getDelegate();
    }

    protected void setUp() throws Exception {
        this.elementHandler = DefaultHandlers.ELEMENT_HANDLER;
        this.simpleHandler = DefaultHandlers.SIMPLE_HANDLER;
        DefaultHandlers.SIMPLE_HANDLER = DefaultHandlers.ELEMENT_HANDLER = DEBUG_ELEMENT_HANDLER;
        super.setUp();
        this.configureLogging();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        DefaultHandlers.ELEMENT_HANDLER = this.elementHandler;
        this.elementHandler = null;
        DefaultHandlers.SIMPLE_HANDLER = this.simpleHandler;
        this.simpleHandler = null;
    }

    protected <T> T unmarshalObject(Class<T> expected) throws Exception {
        String testXml = this.findTestXml();
        Object o = this.unmarshal(testXml);
        AbstractBuilderTest.assertNotNull((Object)o);
        this.getLog().debug((Object)("Unmarshalled " + o + " of type " + o.getClass().getName()));
        try {
            return expected.cast(o);
        }
        catch (ClassCastException e) {
            AbstractBuilderTest.fail((String)("Expected " + expected.getName() + " got " + o.getClass().getName()));
            throw new UnreachableStatementException();
        }
    }

    protected Object unmarshal(String name, Class<?> expected) throws Exception {
        Object object = this.unmarshal(name);
        if (object == null) {
            AbstractBuilderTest.fail((String)("No object from " + name));
        }
        AbstractBuilderTest.assertTrue((String)("Object '" + object + "' cannot be assigned to " + expected.getName()), (boolean)expected.isAssignableFrom(object.getClass()));
        return object;
    }

    protected Object unmarshal(String name) throws Exception {
        String url = this.findXML(name);
        return this.getJBossXBDelegate().unmarshal(url);
    }

    protected String findTestXml() {
        String result = this.rootName + "_" + this.getName() + ".xml";
        if (this.getResource(result) == null) {
            result = this.rootName + ".xml";
        }
        return result;
    }

    protected String getRootName() {
        String longName = ((Object)((Object)this)).getClass().getName();
        int dot = longName.lastIndexOf(46);
        if (dot != -1) {
            longName = longName.substring(dot + 1);
        }
        if ((dot = longName.lastIndexOf("UnitTestCase")) != -1) {
            longName = longName.substring(0, dot);
        }
        return longName;
    }

    protected TermBinding assertSingleSequence(TermBinding term) {
        AbstractBuilderTest.assertNotNull((Object)term);
        AbstractBuilderTest.assertTrue((boolean)(term instanceof SequenceBinding));
        SequenceBinding sequence = (SequenceBinding)term;
        Collection particles = sequence.getParticles();
        AbstractBuilderTest.assertTrue((particles.size() == 1 ? 1 : 0) != 0);
        ParticleBinding particle = (ParticleBinding)particles.iterator().next();
        term = particle.getTerm();
        AbstractBuilderTest.assertNotNull((Object)term);
        return term;
    }

    protected String findXML(String name) {
        URL url = this.getResource(name);
        if (url == null) {
            AbstractBuilderTest.fail((String)(name + " not found"));
        }
        return url.toString();
    }

    public void configureLogging() {
    }
}

