/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class LifecycleTestCase
extends AbstractXMLTest {
    protected LifecycleMetaData getLifecycle(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        LifecycleMetaData lifecycle = bean.getCreate();
        LifecycleTestCase.assertNotNull((Object)lifecycle);
        return lifecycle;
    }

    public void testLifecycle() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle("Lifecycle.xml");
        LifecycleTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleTestCase.assertNull((Object)lifecycle.getAnnotations());
        LifecycleTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithMethod() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle("LifecycleWithMethod.xml");
        LifecycleTestCase.assertEquals((String)"Method", (String)lifecycle.getMethodName());
        LifecycleTestCase.assertNull((Object)lifecycle.getAnnotations());
        LifecycleTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithIgnored() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle("LifecycleWithIgnored.xml");
        LifecycleTestCase.assertTrue((boolean)lifecycle.isIgnored());
        LifecycleTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleTestCase.assertNull((Object)lifecycle.getAnnotations());
        LifecycleTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithAnnotation() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle("LifecycleWithAnnotation.xml");
        LifecycleTestCase.assertNull((Object)lifecycle.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        this.assertAnnotations(expected, lifecycle.getAnnotations());
        LifecycleTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithAnnotations() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle("LifecycleWithAnnotations.xml");
        LifecycleTestCase.assertNull((Object)lifecycle.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation2");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation3");
        this.assertAnnotations(expected, lifecycle.getAnnotations());
        LifecycleTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithParameter() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle("LifecycleWithParameter.xml");
        LifecycleTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleTestCase.assertNull((Object)lifecycle.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        this.assertParameters(expected, lifecycle.getParameters());
    }

    public void testLifecycleWithParameters() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle("LifecycleWithParameters.xml");
        LifecycleTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleTestCase.assertNull((Object)lifecycle.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        expected.add("Parameter2");
        expected.add("Parameter3");
        this.assertParameters(expected, lifecycle.getParameters());
    }

    public static Test suite() {
        return LifecycleTestCase.suite(LifecycleTestCase.class);
    }

    public LifecycleTestCase(String name) {
        super(name);
    }

    protected LifecycleTestCase(String name, boolean useClone) {
        super(name, useClone);
    }
}

