/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class ValueFactoryTestCase
extends AbstractXMLTest {
    protected AbstractValueFactoryMetaData getValueFactory(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        ValueFactoryTestCase.assertNotNull((Object)properties);
        ValueFactoryTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        ValueFactoryTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        ValueFactoryTestCase.assertNotNull((Object)value);
        ValueFactoryTestCase.assertTrue((boolean)(value instanceof AbstractValueFactoryMetaData));
        return (AbstractValueFactoryMetaData)value;
    }

    public void testValueFactoryWithBean() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithBean.xml");
        ValueFactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryTestCase.assertNull((Object)dependency.getDependentState());
    }

    public void testValueFactoryWithParameter() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithParameter.xml");
        ValueFactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryTestCase.assertNull((Object)dependency.getParameters());
        ValueFactoryTestCase.assertEquals((String)"foo.bar.key", (String)dependency.getParameter());
    }

    public void testValueFactoryWithParameters() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithParameters.xml");
        ValueFactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        List parameters = dependency.getParameters();
        ValueFactoryTestCase.assertNotNull((Object)parameters);
        ValueFactoryTestCase.assertFalse((boolean)parameters.isEmpty());
        ValueFactoryTestCase.assertTrue((parameters.size() == 2 ? 1 : 0) != 0);
        ParameterMetaData pmd1 = (ParameterMetaData)parameters.get(0);
        ValueFactoryTestCase.assertNotNull((Object)pmd1);
        ValueMetaData value1 = pmd1.getValue();
        ValueFactoryTestCase.assertNotNull((Object)value1);
        ValueFactoryTestCase.assertEquals((Object)"foo.bar.key", (Object)value1.getUnderlyingValue());
        ParameterMetaData pmd2 = (ParameterMetaData)parameters.get(1);
        ValueFactoryTestCase.assertNotNull((Object)pmd2);
        ValueMetaData value2 = pmd2.getValue();
        ValueFactoryTestCase.assertNotNull((Object)value2);
        ValueFactoryTestCase.assertEquals((Object)"mydefault", (Object)value2.getUnderlyingValue());
        ValueFactoryTestCase.assertNull((Object)dependency.getDependentState());
    }

    public void testValueFactoryWithDefault() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithDefault.xml");
        ValueFactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryTestCase.assertEquals((String)"mydefault", (String)dependency.getDefaultValue());
        ValueFactoryTestCase.assertNull((Object)dependency.getDependentState());
    }

    public void testValueFactoryWithState() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithState.xml");
        ValueFactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)dependency.getDependentState());
    }

    public void testValueFactoryWithWhenRequired() throws Exception {
        AbstractValueFactoryMetaData dependency = this.getValueFactory("ValueFactoryWithWhenRequired.xml");
        ValueFactoryTestCase.assertEquals((Object)"Dummy", (Object)dependency.getValue());
        ValueFactoryTestCase.assertEquals((String)"getValue", (String)dependency.getMethod());
        ValueFactoryTestCase.assertEquals((Object)ControllerState.CREATE, (Object)dependency.getWhenRequiredState());
    }

    public static Test suite() {
        return ValueFactoryTestCase.suite(ValueFactoryTestCase.class);
    }

    public ValueFactoryTestCase(String name) {
        super(name);
    }

    protected ValueFactoryTestCase(String name, boolean useClone) {
        super(name, useClone);
    }
}

