/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.event.support;

import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.logging.Logger;
import org.jboss.test.kernel.event.support.TestEvent;
import org.jboss.test.kernel.event.support.TestFilter;
import org.jboss.test.kernel.event.support.TestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTestCaseSupport {
    private static final Logger log = Logger.getLogger(EventTestCaseSupport.class);

    public static void check(TestListener listener, ArrayList<KernelEvent> expected) throws Exception {
        ArrayList<KernelEvent> received = listener.events;
        ArrayList<KernelEvent> actual = new ArrayList<KernelEvent>(received);
        ArrayList<KernelEvent> expect = new ArrayList<KernelEvent>(expected);
        log.debug((Object)("listener expect=" + expect));
        log.debug((Object)("listener actual=" + actual));
        actual.removeAll(expected);
        EventTestCaseSupport.assertTrue("Didn't expect events: " + actual + " expected=" + expected, actual.isEmpty());
        expect.removeAll(received);
        EventTestCaseSupport.assertTrue("Expected events: " + expect + " received=" + received, expect.isEmpty());
    }

    public static void check(TestFilter filter, ArrayList<KernelEvent> expected) throws Exception {
        ArrayList<KernelEvent> filtered = filter.events;
        ArrayList<KernelEvent> actual = new ArrayList<KernelEvent>(filtered);
        ArrayList<KernelEvent> expect = new ArrayList<KernelEvent>(expected);
        log.debug((Object)("filter expect=" + expect));
        log.debug((Object)("filter actual=" + actual));
        actual.removeAll(expected);
        EventTestCaseSupport.assertTrue("Didn't expect to filter events: " + actual + " expected=" + expected, actual.isEmpty());
        expect.removeAll(filtered);
        EventTestCaseSupport.assertTrue("Expected to filter events: " + expect + " filtered=" + filtered, expect.isEmpty());
    }

    public static TestEvent makeExpected(Object source, String type, long sequence, Object context, Object handback) {
        return new TestEvent(source, type, sequence, context, handback);
    }

    public static void assertTrue(String text, boolean assertion) {
        if (!assertion) {
            throw new AssertionFailedError(text);
        }
    }
}

