/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.event.test;

import java.util.ArrayList;
import junit.framework.Test;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.event.support.EventTestCaseSupport;
import org.jboss.test.kernel.event.support.TestEmitter;
import org.jboss.test.kernel.event.support.TestFilter;
import org.jboss.test.kernel.event.support.TestListener;

public class EmitterTestCase
extends AbstractKernelTest {
    public static Test suite() {
        return EmitterTestCase.suite(EmitterTestCase.class);
    }

    public EmitterTestCase(String name) {
        super(name);
    }

    public void testSimpleFireEvent() throws Throwable {
        TestEmitter emitter = new TestEmitter();
        TestListener listener = new TestListener();
        emitter.registerListener(listener, null, null);
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, null));
        EventTestCaseSupport.check(listener, expected);
    }

    public void testDoubleFireEvent() throws Throwable {
        TestEmitter emitter = new TestEmitter();
        TestListener listener = new TestListener();
        emitter.registerListener(listener, null, null);
        emitter.testFire("testtype", null);
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, null));
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 1L, null, null));
        EventTestCaseSupport.check(listener, expected);
    }

    public void testFilter() throws Throwable {
        TestEmitter emitter = new TestEmitter();
        TestListener listener = new TestListener();
        TestFilter filter = new TestFilter();
        emitter.registerListener(listener, filter, null);
        emitter.testFire("testtype", null);
        filter.fireEvent = false;
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, null));
        EventTestCaseSupport.check(listener, expected);
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 1L, null, null));
        EventTestCaseSupport.check(filter, expected);
    }

    public void testHandback() throws Throwable {
        TestEmitter emitter = new TestEmitter();
        TestListener listener = new TestListener();
        TestFilter filter = new TestFilter();
        Object handback = new Object();
        emitter.registerListener(listener, filter, handback);
        emitter.testFire("testtype", null);
        ArrayList<KernelEvent> expected = new ArrayList<KernelEvent>();
        expected.add(EventTestCaseSupport.makeExpected((Object)emitter, "testtype", 0L, null, handback));
        EventTestCaseSupport.check(listener, expected);
        EventTestCaseSupport.check(filter, expected);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }
}

