/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import junit.framework.Test;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class ConfigureAttributeFromObjectTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return ConfigureAttributeFromObjectTestCase.suite(ConfigureAttributeFromObjectTestCase.class);
    }

    public ConfigureAttributeFromObjectTestCase(String name) {
        super(name);
    }

    public void testStringAttribute() throws Throwable {
        String value = new String("StringValue");
        SimpleBean bean = this.configureSimpleBean("AString", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getAString());
    }

    public void testByteAttribute() throws Throwable {
        Byte value = new Byte("12");
        SimpleBean bean = this.configureSimpleBean("AByte", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getAByte());
    }

    public void testBooleanAttribute() throws Throwable {
        Boolean value = Boolean.TRUE;
        SimpleBean bean = this.configureSimpleBean("ABoolean", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getABoolean());
    }

    public void testCharacterAttribute() throws Throwable {
        Character value = new Character('a');
        SimpleBean bean = this.configureSimpleBean("ACharacter", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getACharacter());
    }

    public void testShortAttribute() throws Throwable {
        Short value = new Short("123");
        SimpleBean bean = this.configureSimpleBean("AShort", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getAShort());
    }

    public void testIntegerAttribute() throws Throwable {
        Integer value = new Integer("1234");
        SimpleBean bean = this.configureSimpleBean("anInt", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getAnInt());
    }

    public void testLongAttribute() throws Throwable {
        Long value = new Long("12345");
        SimpleBean bean = this.configureSimpleBean("ALong", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getALong());
    }

    public void testFloatAttribute() throws Throwable {
        Float value = new Float("3.14");
        SimpleBean bean = this.configureSimpleBean("AFloat", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getAFloat());
    }

    public void testDoubleAttribute() throws Throwable {
        Double value = new Double("3.14e12");
        SimpleBean bean = this.configureSimpleBean("ADouble", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getADouble());
    }

    public void testDateAttribute() throws Throwable {
        Date value = this.createDate(2001, 1, 1);
        SimpleBean bean = this.configureSimpleBean("ADate", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getADate());
    }

    public void testBigDecimalAttribute() throws Throwable {
        BigDecimal value = new BigDecimal("12e4");
        SimpleBean bean = this.configureSimpleBean("ABigDecimal", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getABigDecimal());
    }

    public void testBigIntegerAttribute() throws Throwable {
        BigInteger value = new BigInteger("123456");
        SimpleBean bean = this.configureSimpleBean("ABigInteger", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)bean.getABigInteger());
    }

    public void testPrimitiveByteAttribute() throws Throwable {
        Byte value = new Byte("12");
        SimpleBean bean = this.configureSimpleBean("abyte", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((byte)value, (byte)bean.getAbyte());
    }

    public void testPrimitiveBooleanAttribute() throws Throwable {
        Boolean value = Boolean.TRUE;
        SimpleBean bean = this.configureSimpleBean("aboolean", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((boolean)value, (boolean)bean.isAboolean());
    }

    public void testPrimitiveCharacterAttribute() throws Throwable {
        Character value = new Character('a');
        SimpleBean bean = this.configureSimpleBean("achar", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((char)value.charValue(), (char)bean.getAchar());
    }

    public void testPrimitiveShortAttribute() throws Throwable {
        Short value = new Short("123");
        SimpleBean bean = this.configureSimpleBean("ashort", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((short)value, (short)bean.getAshort());
    }

    public void testPrimitiveIntegerAttribute() throws Throwable {
        Integer value = new Integer("1234");
        SimpleBean bean = this.configureSimpleBean("anint", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((int)value, (int)bean.getAnint());
    }

    public void testPrimitiveLongAttribute() throws Throwable {
        Long value = new Long("12345");
        SimpleBean bean = this.configureSimpleBean("along", value);
        ConfigureAttributeFromObjectTestCase.assertEquals((long)value, (long)bean.getAlong());
    }

    public void testPrimitiveFloatAttribute() throws Throwable {
        Float value = new Float("3.14");
        SimpleBean bean = this.configureSimpleBean("afloat", value);
        this.assertEquals(value.floatValue(), bean.getAfloat());
    }

    public void testPrimitiveDoubleAttribute() throws Throwable {
        Double value = new Double("3.14e12");
        SimpleBean bean = this.configureSimpleBean("adouble", value);
        this.assertEquals(value, bean.getAdouble());
    }

    public void testNumber() throws Throwable {
        Long value = new Long("4");
        SimpleBean bean = this.configureSimpleBean("ANumber", value);
        Number number = bean.getANumber();
        ConfigureAttributeFromObjectTestCase.assertEquals(Long.class, number.getClass());
        ConfigureAttributeFromObjectTestCase.assertEquals((Object)value, (Object)number);
    }

    protected SimpleBean configureSimpleBean(String name, Object value) throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        BeanInfo info = configurator.getBeanInfo(SimpleBean.class);
        SimpleBean bean = (SimpleBean)this.instantiate(configurator, info);
        AbstractPropertyMetaData metaData = new AbstractPropertyMetaData(name, value);
        this.configure((Object)bean, info, (PropertyMetaData)metaData);
        return bean;
    }
}

