/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.registry.test;

import junit.framework.Test;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.registry.support.SimpleRegistryFactory;

public class RegistryFactoryTestCase
extends AbstractKernelTest {
    public static Test suite() {
        return RegistryFactoryTestCase.suite(RegistryFactoryTestCase.class);
    }

    public RegistryFactoryTestCase(String name) {
        super(name);
    }

    public void testAddRegistryFactory() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        SimpleRegistryFactory factory = new SimpleRegistryFactory();
        Object testObject = new Object();
        factory.entries.put("Name1", testObject);
        KernelRegistryEntry factoryEntry = RegistryFactoryTestCase.makeEntry(factory);
        registry.registerEntry((Object)"Factory", factoryEntry);
        KernelRegistryEntry result = registry.getEntry((Object)"Name1");
        RegistryFactoryTestCase.assertNotNull((Object)result);
        Object target = result.getTarget();
        RegistryFactoryTestCase.assertNotNull((Object)target);
        RegistryFactoryTestCase.assertTrue((String)"Should be the same object", (testObject == target ? 1 : 0) != 0);
    }

    public void testRemoveRegistryFactory() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        SimpleRegistryFactory factory = new SimpleRegistryFactory();
        Object testObject = new Object();
        factory.entries.put("Name1", testObject);
        KernelRegistryEntry factoryEntry = RegistryFactoryTestCase.makeEntry(factory);
        registry.registerEntry((Object)"Factory", factoryEntry);
        registry.unregisterEntry((Object)"Factory");
        try {
            registry.getEntry((Object)"Name1");
            RegistryFactoryTestCase.fail((String)"Should not be here");
        }
        catch (KernelRegistryEntryNotFoundException expected) {
            // empty catch block
        }
    }

    public void testAddRemoveAddRegistryFactory() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        SimpleRegistryFactory factory = new SimpleRegistryFactory();
        Object testObject = new Object();
        factory.entries.put("Name1", testObject);
        KernelRegistryEntry factoryEntry = RegistryFactoryTestCase.makeEntry(factory);
        registry.registerEntry((Object)"Factory", factoryEntry);
        registry.unregisterEntry((Object)"Factory");
        registry.registerEntry((Object)"Factory", factoryEntry);
        KernelRegistryEntry result = registry.getEntry((Object)"Name1");
        RegistryFactoryTestCase.assertNotNull((Object)result);
        Object target = result.getTarget();
        RegistryFactoryTestCase.assertNotNull((Object)target);
        RegistryFactoryTestCase.assertTrue((String)"Should be the same object", (testObject == target ? 1 : 0) != 0);
    }

    public void testDuplicateRegistryFactory() throws Throwable {
        KernelRegistry registry = this.bootstrap().getRegistry();
        SimpleRegistryFactory factory1 = new SimpleRegistryFactory();
        Object testObject1 = new Object();
        factory1.entries.put("Name1", testObject1);
        KernelRegistryEntry factoryEntry1 = RegistryFactoryTestCase.makeEntry(factory1);
        registry.registerEntry((Object)"Factory1", factoryEntry1);
        SimpleRegistryFactory factory2 = new SimpleRegistryFactory();
        Object testObject2 = new Object();
        Object testObject3 = new Object();
        factory2.entries.put("Name1", testObject2);
        factory2.entries.put("Name2", testObject3);
        KernelRegistryEntry factoryEntry2 = RegistryFactoryTestCase.makeEntry(factory2);
        registry.registerEntry((Object)"Factory2", factoryEntry2);
        KernelRegistryEntry result = registry.getEntry((Object)"Name1");
        RegistryFactoryTestCase.assertNotNull((Object)result);
        Object target = result.getTarget();
        RegistryFactoryTestCase.assertNotNull((Object)target);
        RegistryFactoryTestCase.assertTrue((String)"Should be the object from the first factory", (testObject1 == target ? 1 : 0) != 0);
        result = registry.getEntry((Object)"Name2");
        RegistryFactoryTestCase.assertNotNull((Object)result);
        target = result.getTarget();
        RegistryFactoryTestCase.assertNotNull((Object)target);
        RegistryFactoryTestCase.assertTrue((String)"Should be the object from the second factory", (testObject3 == target ? 1 : 0) != 0);
        registry.unregisterEntry((Object)"Factory1");
        result = registry.getEntry((Object)"Name1");
        RegistryFactoryTestCase.assertNotNull((Object)result);
        target = result.getTarget();
        RegistryFactoryTestCase.assertNotNull((Object)target);
        RegistryFactoryTestCase.assertTrue((String)"Should be the object from the second factory", (testObject2 == target ? 1 : 0) != 0);
        registry.registerEntry((Object)"Factory1", factoryEntry1);
        result = registry.getEntry((Object)"Name1");
        RegistryFactoryTestCase.assertNotNull((Object)result);
        target = result.getTarget();
        RegistryFactoryTestCase.assertNotNull((Object)target);
        RegistryFactoryTestCase.assertTrue((String)"Should be the object from the second factory", (testObject2 == target ? 1 : 0) != 0);
        registry.unregisterEntry((Object)"Factory1");
        registry.unregisterEntry((Object)"Factory2");
        try {
            registry.getEntry((Object)"Name1");
            RegistryFactoryTestCase.fail((String)"Should not be here");
        }
        catch (KernelRegistryEntryNotFoundException expected) {
            // empty catch block
        }
    }

    protected void configureLoggingAfterBootstrap() {
    }
}

