/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.search;

import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.annotations.support.SearchInjection;
import org.jboss.test.kernel.annotations.test.search.AbstractSearchAnnotationSupportTest;

public class OrderSearchAnnotationSupportTestCase
extends AbstractSearchAnnotationSupportTest {
    public OrderSearchAnnotationSupportTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return OrderSearchAnnotationSupportTestCase.suite(OrderSearchAnnotationSupportTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWrongOrder() throws Throwable {
        KernelController controller = this.getController();
        KernelControllerContext context = controller.install((BeanMetaData)new AbstractBeanMetaData("si", SearchInjection.class.getName()));
        OrderSearchAnnotationSupportTestCase.assertEquals((Object)ControllerState.INSTANTIATED, (Object)context.getState());
        ArrayList<ControllerContext> contexts = new ArrayList<ControllerContext>();
        try {
            contexts.add(this.install("child", "main", "core", 1));
            contexts.add(this.install("parent", "main", null, -1));
            contexts.add(this.install("local", "main", "core", -1));
            contexts.add(this.install("top", null, null, -1));
            controller.change((ControllerContext)context, ControllerState.INSTALLED);
            OrderSearchAnnotationSupportTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context.getState());
            this.doTestAfterInstall(context.getTarget());
        }
        finally {
            ListIterator iter = contexts.listIterator(contexts.size());
            while (iter.hasPrevious()) {
                Object name = ((ControllerContext)iter.previous()).getName();
                this.getController().uninstall(name);
            }
        }
    }

    protected void doTestAfterInstall(Object target) {
        SearchInjection si = (SearchInjection)target;
        this.assertScopeTester(si.getTop(), "top");
        this.assertScopeTester(si.getParent(), "parent");
        this.assertScopeTester(si.getLocal(), "local");
        this.assertScopeTester(si.getChildrenOnly(), "child");
        this.assertScopeTester(si.getLeaves(), "child");
    }
}

