/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.test.kernel.deployment.xml.support.TestBeanMetaDataFactory;
import org.jboss.test.kernel.deployment.xml.support.TestBeanMetaDataFactory1;
import org.jboss.test.kernel.deployment.xml.support.TestBeanMetaDataFactory2;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;

public class DeploymentJaxbTestCase
extends AbstractMCTest {
    public void testDeployment() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertNull((Object)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getBeans());
    }

    public void testDeploymentWithName() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getBeans());
    }

    public void testDeploymentWithClassLoader() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNotNull((Object)deployment.getClassLoader());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getBeans());
    }

    public void testDeploymentWithBean() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentJaxbTestCase.assertNotNull((Object)beans);
        DeploymentJaxbTestCase.assertEquals((int)1, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithMultipleBeans() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentJaxbTestCase.assertNotNull((Object)beans);
        DeploymentJaxbTestCase.assertEquals((int)3, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean2", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean3", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithBeanFactory() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentJaxbTestCase.assertNotNull((Object)beans);
        DeploymentJaxbTestCase.assertEquals((int)1, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithMultipleBeanFactorys() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentJaxbTestCase.assertNotNull((Object)beans);
        DeploymentJaxbTestCase.assertEquals((int)3, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean2", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean3", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
    }

    public void testDeploymentWithMultipleBeanMetaDataFactorys() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        List beanFactories = deployment.getBeanFactories();
        DeploymentJaxbTestCase.assertNotNull((Object)beanFactories);
        DeploymentJaxbTestCase.assertEquals((int)3, (int)beanFactories.size());
        BeanMetaDataFactory factory = (BeanMetaDataFactory)beanFactories.get(0);
        DeploymentJaxbTestCase.assertEquals((String)TestBeanMetaDataFactory.class.getName(), (String)factory.getClass().getName());
        factory = (BeanMetaDataFactory)beanFactories.get(1);
        DeploymentJaxbTestCase.assertEquals((String)TestBeanMetaDataFactory1.class.getName(), (String)factory.getClass().getName());
        factory = (BeanMetaDataFactory)beanFactories.get(2);
        DeploymentJaxbTestCase.assertEquals((String)TestBeanMetaDataFactory2.class.getName(), (String)factory.getClass().getName());
        List beans = deployment.getBeans();
        DeploymentJaxbTestCase.assertNotNull((Object)beans);
        DeploymentJaxbTestCase.assertEquals((int)6, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean2", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean3", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(3);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean4", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(4);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean5", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(5);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean6", (String)bean.getBean());
    }

    public void testDeploymentWithBeanMetaDataFactory() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        List beanFactories = deployment.getBeanFactories();
        DeploymentJaxbTestCase.assertNotNull((Object)beanFactories);
        DeploymentJaxbTestCase.assertEquals((int)1, (int)beanFactories.size());
        BeanMetaDataFactory factory = (BeanMetaDataFactory)beanFactories.get(0);
        DeploymentJaxbTestCase.assertEquals((String)TestBeanMetaDataFactory.class.getName(), (String)factory.getClass().getName());
        List beans = deployment.getBeans();
        DeploymentJaxbTestCase.assertNotNull((Object)beans);
        DeploymentJaxbTestCase.assertEquals((int)2, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean2", (String)bean.getBean());
    }

    public void testDeploymentWithMixed() throws Exception {
        AbstractKernelDeployment deployment = this.unmarshalDeployment();
        DeploymentJaxbTestCase.assertEquals((String)"SimpleDeployment", (String)deployment.getName());
        DeploymentJaxbTestCase.assertNull((Object)deployment.getClassLoader());
        List beans = deployment.getBeans();
        DeploymentJaxbTestCase.assertNotNull((Object)beans);
        DeploymentJaxbTestCase.assertEquals((int)8, (int)beans.size());
        BeanMetaData bean = (BeanMetaData)beans.get(0);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(1);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean2", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(2);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean1", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(3);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean2", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(4);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean3", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)Object.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(5);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean4", (String)bean.getName());
        DeploymentJaxbTestCase.assertEquals((String)GenericBeanFactory.class.getName(), (String)bean.getBean());
        bean = (BeanMetaData)beans.get(6);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean3", (String)bean.getBean());
        bean = (BeanMetaData)beans.get(7);
        DeploymentJaxbTestCase.assertNotNull((Object)bean);
        DeploymentJaxbTestCase.assertEquals((String)"Bean4", (String)bean.getBean());
    }

    public static Test suite() {
        return DeploymentJaxbTestCase.suite(DeploymentJaxbTestCase.class);
    }

    public DeploymentJaxbTestCase(String name) {
        super(name);
    }
}

