/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class ConfigureFromStringTestCase
extends AbstractKernelConfigTest {
    KernelConfigurator configurator;
    BeanInfo info;
    AbstractBeanMetaData metaData;
    String stringValue = "StringValue";
    Byte byteValue = new Byte("12");
    Boolean booleanValue = Boolean.TRUE;
    Short shortValue = new Short("123");
    Integer integerValue = new Integer("1234");
    Long longValue = new Long("12345");
    Float floatValue = new Float("3.14");
    Double doubleValue = new Double("3.14e12");
    Date dateValue = this.createDate("Mon Jan 01 00:00:00 CET 2001");
    BigDecimal bigDecimalValue = new BigDecimal("12e4");
    BigInteger bigIntegerValue = new BigInteger("123456");
    SimpleBean.Alphabet enumValue = SimpleBean.Alphabet.Z;

    public static Test suite() {
        return ConfigureFromStringTestCase.suite(ConfigureFromStringTestCase.class);
    }

    public ConfigureFromStringTestCase(String name) {
        super(name);
    }

    public ConfigureFromStringTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testConfigure() throws Throwable {
        SimpleBean bean = this.configure();
        ConfigureFromStringTestCase.assertEquals((String)this.stringValue, (String)bean.getAString());
        ConfigureFromStringTestCase.assertEquals((Object)this.byteValue, (Object)bean.getAByte());
        ConfigureFromStringTestCase.assertEquals((Object)this.booleanValue, (Object)bean.getABoolean());
        ConfigureFromStringTestCase.assertEquals((Object)this.shortValue, (Object)bean.getAShort());
        ConfigureFromStringTestCase.assertEquals((Object)this.integerValue, (Object)bean.getAnInt());
        ConfigureFromStringTestCase.assertEquals((Object)this.longValue, (Object)bean.getALong());
        ConfigureFromStringTestCase.assertEquals((Object)this.floatValue, (Object)bean.getAFloat());
        ConfigureFromStringTestCase.assertEquals((Object)this.doubleValue, (Object)bean.getADouble());
        ConfigureFromStringTestCase.assertEquals((Object)this.dateValue, (Object)bean.getADate());
        ConfigureFromStringTestCase.assertEquals((Object)this.bigDecimalValue, (Object)bean.getABigDecimal());
        ConfigureFromStringTestCase.assertEquals((Object)this.bigIntegerValue, (Object)bean.getABigInteger());
        ConfigureFromStringTestCase.assertEquals((byte)this.byteValue, (byte)bean.getAbyte());
        ConfigureFromStringTestCase.assertEquals((boolean)this.booleanValue, (boolean)bean.isAboolean());
        ConfigureFromStringTestCase.assertEquals((short)this.shortValue, (short)bean.getAshort());
        ConfigureFromStringTestCase.assertEquals((int)this.integerValue, (int)bean.getAnint());
        ConfigureFromStringTestCase.assertEquals((long)this.longValue, (long)bean.getAlong());
        this.assertEquals(this.floatValue.floatValue(), bean.getAfloat());
        this.assertEquals(this.doubleValue, bean.getAdouble());
        Number number = bean.getANumber();
        ConfigureFromStringTestCase.assertEquals(Long.class, number.getClass());
        ConfigureFromStringTestCase.assertEquals((Object)this.longValue, (Object)number);
        ConfigureFromStringTestCase.assertEquals((String)this.stringValue, (String)bean.getOverloadedProperty());
        ConfigureFromStringTestCase.assertEquals((Object)((Object)this.enumValue), (Object)((Object)bean.getEnumProperty()));
        this.unconfigure(bean);
        ConfigureFromStringTestCase.assertEquals(null, (String)bean.getAString());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getAByte());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getABoolean());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getAShort());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getAnInt());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getALong());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getAFloat());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getADouble());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getADate());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getABigDecimal());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getABigInteger());
        ConfigureFromStringTestCase.assertEquals((byte)this.byteValue, (byte)bean.getAbyte());
        ConfigureFromStringTestCase.assertEquals((boolean)this.booleanValue, (boolean)bean.isAboolean());
        ConfigureFromStringTestCase.assertEquals((short)this.shortValue, (short)bean.getAshort());
        ConfigureFromStringTestCase.assertEquals((int)this.integerValue, (int)bean.getAnint());
        ConfigureFromStringTestCase.assertEquals((long)this.longValue, (long)bean.getAlong());
        this.assertEquals(this.floatValue.floatValue(), bean.getAfloat());
        this.assertEquals(this.doubleValue, bean.getAdouble());
        ConfigureFromStringTestCase.assertEquals(null, (Object)bean.getANumber());
        ConfigureFromStringTestCase.assertEquals(null, (String)bean.getOverloadedProperty());
        ConfigureFromStringTestCase.assertEquals(null, (Object)((Object)bean.getEnumProperty()));
    }

    protected SimpleBean configure() throws Throwable {
        Kernel kernel = this.bootstrap();
        this.configurator = kernel.getConfigurator();
        this.info = this.configurator.getBeanInfo(SimpleBean.class);
        SimpleBean bean = (SimpleBean)this.instantiate(this.configurator, this.info);
        this.metaData = new AbstractBeanMetaData();
        HashSet<AbstractPropertyMetaData> attributes = new HashSet<AbstractPropertyMetaData>();
        attributes.add(new AbstractPropertyMetaData("AString", this.stringValue));
        attributes.add(new AbstractPropertyMetaData("AByte", this.byteValue.toString()));
        attributes.add(new AbstractPropertyMetaData("ABoolean", this.booleanValue.toString()));
        attributes.add(new AbstractPropertyMetaData("AShort", this.shortValue.toString()));
        attributes.add(new AbstractPropertyMetaData("anInt", this.integerValue.toString()));
        attributes.add(new AbstractPropertyMetaData("ALong", this.longValue.toString()));
        attributes.add(new AbstractPropertyMetaData("AFloat", this.floatValue.toString()));
        attributes.add(new AbstractPropertyMetaData("ADouble", this.doubleValue.toString()));
        attributes.add(new AbstractPropertyMetaData("ADate", this.dateValue.toString()));
        attributes.add(new AbstractPropertyMetaData("ABigDecimal", this.bigDecimalValue.toString()));
        attributes.add(new AbstractPropertyMetaData("ABigInteger", this.bigIntegerValue.toString()));
        attributes.add(new AbstractPropertyMetaData("abyte", this.byteValue.toString()));
        attributes.add(new AbstractPropertyMetaData("aboolean", this.booleanValue.toString()));
        attributes.add(new AbstractPropertyMetaData("ashort", this.shortValue.toString()));
        attributes.add(new AbstractPropertyMetaData("anint", this.integerValue.toString()));
        attributes.add(new AbstractPropertyMetaData("along", this.longValue.toString()));
        attributes.add(new AbstractPropertyMetaData("afloat", this.floatValue.toString()));
        attributes.add(new AbstractPropertyMetaData("adouble", this.doubleValue.toString()));
        attributes.add(new AbstractPropertyMetaData("overloadedProperty", this.stringValue));
        AbstractPropertyMetaData number = new AbstractPropertyMetaData("ANumber", this.longValue.toString(), "java.lang.Long");
        ((StringValueMetaData)number.getValue()).setConfigurator(this.configurator);
        attributes.add(number);
        attributes.add(new AbstractPropertyMetaData("enumProperty", this.enumValue.toString()));
        this.metaData.setProperties(attributes);
        this.configure((Object)bean, this.info, (BeanMetaData)this.metaData);
        return bean;
    }

    protected void unconfigure(SimpleBean bean) throws Throwable {
        this.unconfigure(bean, this.info);
    }
}

