/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBeanInstallSelf;
import org.jboss.test.kernel.dependency.support.SimpleBeanInstallsAware;
import org.jboss.test.kernel.dependency.test.AbstractKernelDependencyTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallSelfDependencyTestCase
extends AbstractKernelDependencyTest {
    public static Test suite() {
        return InstallSelfDependencyTestCase.suite(InstallSelfDependencyTestCase.class);
    }

    public InstallSelfDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public InstallSelfDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testInstallSelfDependencyCorrectOrder() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context = this.assertInstall(0, "Name1");
        SimpleBeanInstallSelf bean = (SimpleBeanInstallSelf)context.getTarget();
        InstallSelfDependencyTestCase.assertNotNull((Object)bean);
        InstallSelfDependencyTestCase.assertTrue((boolean)bean.getInstalled());
    }

    public void testInstallSelfDependencyReinstall() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context = this.assertInstall(0, "Name1");
        SimpleBeanInstallSelf bean = (SimpleBeanInstallSelf)context.getTarget();
        InstallSelfDependencyTestCase.assertNotNull((Object)bean);
        InstallSelfDependencyTestCase.assertTrue((boolean)bean.getInstalled());
        this.assertUninstall("Name1");
        InstallSelfDependencyTestCase.assertFalse((boolean)bean.getInstalled());
        context = this.assertInstall(0, "Name1");
        bean = (SimpleBeanInstallSelf)context.getTarget();
        InstallSelfDependencyTestCase.assertNotNull((Object)bean);
        InstallSelfDependencyTestCase.assertTrue((boolean)bean.getInstalled());
    }

    public void testWhenRequiredInstalls() throws Throwable {
        this.setupBeanMetaDatas();
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBeanInstallsAware bean = (SimpleBeanInstallsAware)context2.getTarget();
        InstallSelfDependencyTestCase.assertNotNull((Object)bean);
        Set<ControllerState> states = bean.getStates();
        InstallSelfDependencyTestCase.assertNotNull(states);
        InstallSelfDependencyTestCase.assertEquals((int)4, (int)states.size());
        this.assertUninstall(context2.getName().toString());
        InstallSelfDependencyTestCase.assertEquals((int)1, (int)states.size());
        ControllerState state = states.iterator().next();
        InstallSelfDependencyTestCase.assertEquals((Object)ControllerState.DESCRIBED, (Object)state);
    }

    protected void setupBeanMetaDatas() throws Throwable {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanInstallSelf.class.getName());
        ArrayList<AbstractInstallMetaData> installs = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData install = new AbstractInstallMetaData();
        install.setMethodName("install");
        installs.add(install);
        metaData1.setInstalls(installs);
        ArrayList<AbstractInstallMetaData> uninstalls = new ArrayList<AbstractInstallMetaData>();
        AbstractInstallMetaData uninstall = new AbstractInstallMetaData();
        uninstall.setMethodName("uninstall");
        uninstalls.add(uninstall);
        metaData1.setUninstalls(uninstalls);
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("Name2", SimpleBeanInstallsAware.class.getName());
        ArrayList<InstallMetaData> installs2 = new ArrayList<InstallMetaData>();
        this.addInstalls(ControllerState.INSTANTIATED, installs2, true);
        this.addInstalls(ControllerState.CONFIGURED, installs2, true);
        this.addInstalls(ControllerState.CREATE, installs2, true);
        this.addInstalls(ControllerState.START, installs2, true);
        metaData2.setInstalls(installs2);
        ArrayList<InstallMetaData> uninstalls2 = new ArrayList<InstallMetaData>();
        this.addInstalls(ControllerState.INSTANTIATED, uninstalls2, false);
        this.addInstalls(ControllerState.CONFIGURED, uninstalls2, false);
        this.addInstalls(ControllerState.CREATE, uninstalls2, false);
        this.addInstalls(ControllerState.START, uninstalls2, false);
        metaData2.setUninstalls(uninstalls2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }

    protected void addInstalls(ControllerState state, List<InstallMetaData> installs, boolean add) {
        AbstractInstallMetaData install = new AbstractInstallMetaData();
        install.setState(state);
        install.setMethodName((add ? "add" : "remove") + state.getStateString());
        AbstractInjectionValueMetaData injection = new AbstractInjectionValueMetaData();
        injection.setFromContext(FromContext.STATE);
        AbstractParameterMetaData paramater = new AbstractParameterMetaData((ValueMetaData)injection);
        install.setParameters(Collections.singletonList(paramater));
        installs.add((InstallMetaData)install);
    }
}

