/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.support.Annotation1;
import org.jboss.test.kernel.deployment.xml.support.Annotation2;
import org.jboss.test.kernel.deployment.xml.support.Annotation3;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;

public class PropertyJaxbTestCase
extends AbstractMCTest {
    protected PropertyMetaData getProperty() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        Set properties = bean.getProperties();
        PropertyJaxbTestCase.assertNotNull((Object)properties);
        PropertyJaxbTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        PropertyJaxbTestCase.assertNotNull((Object)property);
        return property;
    }

    public void testProperty() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        PropertyJaxbTestCase.assertNull((Object)property.getValue());
    }

    public void testPropertyWithBean() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        ValueMetaData value = property.getValue();
        this.assertBean(value);
    }

    public void testPropertyWithClass() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        AbstractPropertyMetaData apmd = (AbstractPropertyMetaData)this.assertInstanceOf(property, AbstractPropertyMetaData.class);
        PropertyJaxbTestCase.assertEquals((String)"PropertyClass", (String)apmd.getPropertyType());
    }

    public void testPropertyWithAnnotation() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        this.assertAnnotations(expected, property.getAnnotations());
        PropertyJaxbTestCase.assertNull((Object)property.getValue());
    }

    public void testPropertyWithAnnotations() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        expected.add(Annotation2.class.getName());
        expected.add(Annotation3.class.getName());
        this.assertAnnotations(expected, property.getAnnotations());
        PropertyJaxbTestCase.assertNull((Object)property.getValue());
    }

    public void testPropertyWithPlainValue() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertPlainValue("PlainValue", property.getValue());
    }

    public void testPropertyWithValue() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertValue("Value", property.getValue());
    }

    public void testPropertyWithInjection() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertInjection(property.getValue());
    }

    public void testPropertyWithCollection() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertCollection(property.getValue());
    }

    public void testPropertyWithList() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertList(property.getValue());
    }

    public void testPropertyWithSet() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertSet(property.getValue());
    }

    public void testPropertyWithArray() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertArray(property.getValue());
    }

    public void testPropertyWithMap() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertMap(property.getValue());
    }

    public void testPropertyWithThis() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertThis(property.getValue());
    }

    public void testPropertyWithNull() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertNullValue(property.getValue());
    }

    public void testPropertyWithWildcard() throws Exception {
        PropertyMetaData property = this.getProperty();
        PropertyJaxbTestCase.assertNotNull((String)"PropertyName", (Object)property.getName());
        PropertyJaxbTestCase.assertNull((Object)property.getAnnotations());
        this.assertWildcard(property.getValue());
    }

    public static Test suite() {
        return PropertyJaxbTestCase.suite(PropertyJaxbTestCase.class);
    }

    public PropertyJaxbTestCase(String name) {
        super(name);
    }
}

