/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.controller.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import org.jboss.test.AbstractTestCaseWithSetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScopedClassLoader
extends ClassLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("org.jboss.test.kernel")) {
            SecurityManager sm = AbstractTestCaseWithSetup.suspendSecurity();
            try {
                String resourceName = name.replace('.', '/') + ".class";
                URL url = SimpleScopedClassLoader.class.getClassLoader().getResource(resourceName);
                InputStream is = null;
                byte[] bytes = null;
                try {
                    is = url.openStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] tmp = new byte[1024];
                    int read = 0;
                    while ((read = is.read(tmp)) >= 0) {
                        baos.write(tmp, 0, read);
                    }
                    bytes = baos.toByteArray();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load class byte code " + name, e);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                }
                ProtectionDomain pd = AbstractTestCaseWithSetup.class.getProtectionDomain();
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, pd);
                return clazz;
            }
            finally {
                AbstractTestCaseWithSetup.resumeSecurity((SecurityManager)sm);
            }
        }
        return super.loadClass(name, resolve);
    }
}

