/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import junit.framework.Test;
import org.jboss.beans.metadata.plugins.policy.AbstractPolicyMetaData;
import org.jboss.beans.metadata.spi.policy.PolicyMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class PolicyTestCase
extends AbstractXMLTest {
    public PolicyTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return PolicyTestCase.suite(PolicyTestCase.class);
    }

    public void testPolicy() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("Policy.xml", AbstractPolicyMetaData.class);
        PolicyTestCase.assertNull((Object)policy.getName());
        PolicyTestCase.assertNull((Object)policy.getExtends());
        PolicyTestCase.assertNull((Object)policy.getScope());
        PolicyTestCase.assertNull((Object)policy.getAnnotations());
        PolicyTestCase.assertNull((Object)policy.getBindings());
    }

    public void testPolicyWithName() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("PolicyWithName.xml", AbstractPolicyMetaData.class);
        PolicyTestCase.assertEquals((String)"NamedPolicy", (String)policy.getName());
        PolicyTestCase.assertNull((Object)policy.getExtends());
        PolicyTestCase.assertNull((Object)policy.getScope());
        PolicyTestCase.assertNull((Object)policy.getAnnotations());
        PolicyTestCase.assertNull((Object)policy.getBindings());
    }

    public void testPolicyWithExtends() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("PolicyWithExtends.xml", AbstractPolicyMetaData.class);
        PolicyTestCase.assertNull((Object)policy.getName());
        PolicyTestCase.assertEquals((String)"ExtendablePolicy", (String)policy.getExtends());
        PolicyTestCase.assertNull((Object)policy.getScope());
        PolicyTestCase.assertNull((Object)policy.getAnnotations());
        PolicyTestCase.assertNull((Object)policy.getBindings());
    }

    public void testPolicyWithScope() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("PolicyWithScope.xml", AbstractPolicyMetaData.class);
        PolicyTestCase.assertNull((Object)policy.getName());
        PolicyTestCase.assertNull((Object)policy.getExtends());
        PolicyTestCase.assertNotNull((Object)policy.getScope());
        PolicyTestCase.assertEquals((String)"DefaultLevel", (String)policy.getScope().getLevel());
        PolicyTestCase.assertNull((Object)policy.getAnnotations());
        PolicyTestCase.assertNull((Object)policy.getBindings());
    }

    public void testPolicyWithAnnotations() throws Throwable {
    }

    public void testPolicyWithBindings() throws Throwable {
        PolicyMetaData policy = (PolicyMetaData)this.unmarshal("PolicyWithBindings.xml", AbstractPolicyMetaData.class);
        PolicyTestCase.assertNull((Object)policy.getName());
        PolicyTestCase.assertNull((Object)policy.getExtends());
        PolicyTestCase.assertNull((Object)policy.getScope());
        PolicyTestCase.assertNull((Object)policy.getAnnotations());
        PolicyTestCase.assertNotNull((Object)policy.getBindings());
        PolicyTestCase.assertTrue((policy.getBindings().size() > 0 ? 1 : 0) != 0);
    }
}

