/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.lazy.test;

import java.util.Collections;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractLazyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.lazy.support.IRare;
import org.jboss.test.kernel.lazy.support.RareBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyInstantiationTest
extends AbstractKernelTest {
    public LazyInstantiationTest(String name) {
        super(name);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        return new AbstractTestDelegate(clazz);
    }

    protected abstract String getFactoryClassName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazy() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        try {
            AbstractBeanMetaData bean = new AbstractBeanMetaData("bean", RareBean.class.getName());
            bean.setMode(ControllerMode.MANUAL);
            AbstractDemandMetaData demand = new AbstractDemandMetaData((Object)"foobar");
            demand.setWhenRequired(ControllerState.INSTANTIATED);
            bean.setDemands(Collections.singleton(demand));
            KernelControllerContext beanContext = controller.install((BeanMetaData)bean);
            controller.change((ControllerContext)beanContext, ControllerState.NOT_INSTALLED);
            ModifiedLazyMetaData lazy = new ModifiedLazyMetaData("bean", this.getFactoryClassName());
            lazy.setInterfaces(Collections.singleton(IRare.class.getName()));
            KernelControllerContext lazyContext = controller.install((BeanMetaData)lazy);
            LazyInstantiationTest.assertNotNull((Object)lazyContext);
            LazyInstantiationTest.assertEquals((Object)ControllerState.INSTALLED, (Object)lazyContext.getState());
            controller.change((ControllerContext)beanContext, ControllerState.DESCRIBED);
            controller.change((ControllerContext)lazyContext, ControllerState.INSTALLED);
            IRare lazyRare = (IRare)lazyContext.getTarget();
            LazyInstantiationTest.assertNotNull((Object)lazyRare);
            try {
                lazyRare.getHits();
                throw new RuntimeException("Should not be here.");
            }
            catch (Throwable t) {
                this.assertInstanceOf(t, IllegalArgumentException.class);
                controller.install((BeanMetaData)new AbstractBeanMetaData("foobar", Object.class.getName()));
                controller.change((ControllerContext)beanContext, ControllerState.INSTALLED);
                LazyInstantiationTest.assertEquals((int)0, (int)lazyRare.getHits());
                lazyRare.setHits(10);
                LazyInstantiationTest.assertEquals((int)5, (int)lazyRare.checkHits(15));
                controller.uninstall(beanContext.getName());
                LazyInstantiationTest.assertEquals((Object)ControllerState.DESCRIBED, (Object)lazyContext.getState());
                controller.shutdown();
            }
        }
        catch (Throwable throwable) {
            controller.shutdown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnDemand() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        try {
            AbstractBeanMetaData bean = new AbstractBeanMetaData("bean", RareBean.class.getName());
            bean.setMode(ControllerMode.ON_DEMAND);
            KernelControllerContext beanContext = controller.install((BeanMetaData)bean);
            ModifiedLazyMetaData lazy = new ModifiedLazyMetaData("bean", this.getFactoryClassName());
            lazy.setInterfaces(Collections.singleton(IRare.class.getName()));
            KernelControllerContext lazyContext = controller.install((BeanMetaData)lazy);
            LazyInstantiationTest.assertNotNull((Object)lazyContext);
            LazyInstantiationTest.assertEquals((Object)ControllerState.INSTALLED, (Object)lazyContext.getState());
            IRare lazyRare = (IRare)lazyContext.getTarget();
            LazyInstantiationTest.assertNotNull((Object)lazyRare);
            LazyInstantiationTest.assertEquals((Object)ControllerState.NOT_INSTALLED, (Object)beanContext.getState());
            LazyInstantiationTest.assertEquals((int)0, (int)lazyRare.getHits());
            LazyInstantiationTest.assertEquals((Object)ControllerState.INSTALLED, (Object)beanContext.getState());
            lazyRare.setHits(10);
            LazyInstantiationTest.assertEquals((int)5, (int)lazyRare.checkHits(15));
            controller.uninstall(beanContext.getName());
            LazyInstantiationTest.assertEquals((Object)ControllerState.DESCRIBED, (Object)lazyContext.getState());
        }
        finally {
            controller.shutdown();
        }
    }

    private class ModifiedLazyMetaData
    extends AbstractLazyMetaData {
        private static final long serialVersionUID = 1L;

        public ModifiedLazyMetaData(String beanName, String factoryClassName) {
            super(beanName);
            this.setFactoryClassName(factoryClassName);
        }
    }
}

