/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.metadata.basic;

import org.jboss.kernel.plugins.metadata.basic.PolicyCachingBasicKernelMetaDataRepository;
import org.jboss.metadata.plugins.cache.CachePolicyFactory;
import org.jboss.metadata.plugins.cache.ConcurrentLRUCachePolicyFactory;

public class LRUPolicyCachingBasicKernelMetaDataRepository
extends PolicyCachingBasicKernelMetaDataRepository {
    private Integer min;
    private Integer max;

    public LRUPolicyCachingBasicKernelMetaDataRepository() {
    }

    public LRUPolicyCachingBasicKernelMetaDataRepository(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    protected CachePolicyFactory createCachePolicyFactory() {
        if (this.min == null) {
            this.min = LRUPolicyCachingBasicKernelMetaDataRepository.parseInteger(LRUPolicyCachingBasicKernelMetaDataRepository.readSystemProperty("LRUPolicyCaching.min", null));
        }
        if (this.max == null) {
            this.max = LRUPolicyCachingBasicKernelMetaDataRepository.parseInteger(LRUPolicyCachingBasicKernelMetaDataRepository.readSystemProperty("LRUPolicyCaching.max", null));
        }
        if (this.min == null || this.max == null) {
            throw new IllegalArgumentException("Missing min (" + this.min + ") or max (" + this.max + ").");
        }
        this.log.debug((Object)("Creating LRU cache policy, min: " + this.min + ", max: " + this.max));
        return new ConcurrentLRUCachePolicyFactory(this.min.intValue(), this.max.intValue());
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public void setMax(Integer max) {
        this.max = max;
    }
}

