/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.search;

import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Test;
import org.jboss.dependency.plugins.graph.ScopeKeySearchInfo;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.graph.GraphController;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.kernel.annotations.test.search.AbstractSearchAnnotationSupportTest;

public class ScopeKeySearchTestCase
extends AbstractSearchAnnotationSupportTest {
    public ScopeKeySearchTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return ScopeKeySearchTestCase.suite(ScopeKeySearchTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScopeKeyControllers() throws Throwable {
        ArrayList<ControllerContext> contexts = new ArrayList<ControllerContext>();
        try {
            contexts.add(this.assertScopeBean("child", "main", "core", 1));
            contexts.add(this.assertScopeBean("parent", "main", null, -1));
            contexts.add(this.assertScopeBean("local", "main", "core", -1));
        }
        finally {
            ListIterator iter = contexts.listIterator(contexts.size());
            while (iter.hasPrevious()) {
                Object name = ((ControllerContext)iter.previous()).getName();
                this.getController().uninstall(name);
            }
        }
    }

    protected ControllerContext assertScopeBean(String scope, String app, String deployment, int id) throws Throwable {
        ControllerContext context = this.install(scope, app, deployment, id);
        ScopeKey scopeKey = new ScopeKey();
        if (app != null) {
            scopeKey.addScope(CommonLevels.APPLICATION, (Object)app);
        }
        if (deployment != null) {
            scopeKey.addScope(CommonLevels.DEPLOYMENT, (Object)deployment);
        }
        if (id > 0) {
            scopeKey.addScope(CommonLevels.INSTANCE, (Object)("id-" + id));
        }
        ScopeKeySearchInfo searchInfo = new ScopeKeySearchInfo(scopeKey);
        GraphController gc = (GraphController)this.getController();
        ControllerContext lookup = gc.getContext((Object)"bean", null, (SearchInfo)searchInfo);
        ScopeKeySearchTestCase.assertSame((Object)context, (Object)lookup);
        return context;
    }
}

