/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.controller.test;

import junit.framework.Test;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.controller.support.TestBeanRepository;
import org.jboss.test.kernel.controller.test.AbstractControllerTest;

public class InstallErrorTestCase
extends AbstractControllerTest {
    public static Test suite() {
        return InstallErrorTestCase.suite(InstallErrorTestCase.class);
    }

    public InstallErrorTestCase(String name) throws Throwable {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrorInInstallWithSupplies() throws Throwable {
        KernelDeployment repository = this.deploy("InstallErrorTestCase_Repositories.xml");
        try {
            KernelDeployment deployment = this.deploy("InstallErrorTestCase_BeanWithSupply.xml");
            try {
                KernelControllerContext context = this.getControllerContext("Bean", null);
                InstallErrorTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context.getState());
                InstallErrorTestCase.checkThrowable(Error.class, (Throwable)context.getError());
                try {
                    this.getControllerContext("TestSupply", null);
                    InstallErrorTestCase.fail((String)"Should not be here!");
                }
                catch (Throwable throwable) {
                    InstallErrorTestCase.checkThrowable(IllegalStateException.class, (Throwable)throwable);
                }
            }
            finally {
                this.undeploy(deployment);
            }
        }
        finally {
            this.undeploy(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrorInInstallRedeploy() throws Throwable {
        KernelDeployment repository = this.deploy("InstallErrorTestCase_Repositories.xml");
        try {
            KernelDeployment deployment = this.deploy("InstallErrorTestCase_Bean.xml");
            try {
                KernelControllerContext context = this.getControllerContext("Bean", null);
                InstallErrorTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context.getState());
                InstallErrorTestCase.checkThrowable(Error.class, (Throwable)context.getError());
            }
            finally {
                this.undeploy(deployment);
            }
            deployment = this.deploy("InstallErrorTestCase_BeanNoInstall.xml");
            try {
                InstallErrorTestCase.assertNotNull((Object)this.getControllerContext("Bean"));
            }
            finally {
                this.undeploy(deployment);
            }
        }
        finally {
            this.undeploy(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrorInInstall() throws Throwable {
        KernelDeployment repository = this.deploy("InstallErrorTestCase_Repositories.xml");
        try {
            TestBeanRepository repository1 = (TestBeanRepository)this.getBean("Repository1");
            TestBeanRepository repository2 = (TestBeanRepository)this.getBean("Repository2");
            KernelDeployment deployment = this.deploy("InstallErrorTestCase_Bean.xml");
            try {
                KernelControllerContext context = this.getControllerContext("Bean", null);
                InstallErrorTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context.getState());
                InstallErrorTestCase.checkThrowable(Error.class, (Throwable)context.getError());
                InstallErrorTestCase.assertTrue((boolean)repository1.getBeans().isEmpty());
                InstallErrorTestCase.assertTrue((boolean)repository2.getBeans().isEmpty());
            }
            finally {
                this.undeploy(deployment);
            }
        }
        finally {
            this.undeploy(repository);
        }
    }
}

