/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.Collections;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.test.kernel.dependency.support.NestedBean;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class NestedPropertyTestCase
extends OldAbstractKernelDependencyTest {
    public NestedPropertyTestCase(String name) throws Throwable {
        super(name);
    }

    public NestedPropertyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public static Test suite() {
        return NestedPropertyTestCase.suite(NestedPropertyTestCase.class);
    }

    public void testNestedSet() throws Throwable {
        this.buildSetMetaData();
        ControllerContext context = this.assertInstall(0, "NestedBean");
        Object target = context.getTarget();
        NestedPropertyTestCase.assertNotNull((Object)target);
        this.assertInstanceOf(target, NestedBean.class);
        NestedBean root = (NestedBean)target;
        NestedBean lev1 = root.getBean();
        NestedPropertyTestCase.assertNotNull((Object)lev1);
        NestedBean lev2 = lev1.getBean();
        NestedPropertyTestCase.assertNotNull((Object)lev2);
        NestedPropertyTestCase.assertEquals((String)"String12", (String)lev2.getString());
    }

    public void testNestedInject() throws Throwable {
        this.buildInjectMetaData();
        ControllerContext context = this.assertInstall(1, "NestedBean");
        Object target = context.getTarget();
        NestedPropertyTestCase.assertNotNull((Object)target);
        this.assertInstanceOf(target, NestedBean.class);
        NestedBean root = (NestedBean)target;
        NestedBean lev1 = root.getBean();
        NestedPropertyTestCase.assertNotNull((Object)lev1);
        NestedBean lev2 = lev1.getBean();
        NestedPropertyTestCase.assertNotNull((Object)lev2);
        NestedPropertyTestCase.assertEquals((String)"String1234", (String)lev2.getString());
        ControllerContext injecteeCC = this.assertInstall(0, "InjecteeBean");
        Object injectee = injecteeCC.getTarget();
        NestedPropertyTestCase.assertNotNull((Object)injectee);
        this.assertInstanceOf(injectee, NestedBean.class);
        NestedBean injecteeBean = (NestedBean)injectee;
        NestedPropertyTestCase.assertEquals((String)"String1234", (String)injecteeBean.getString());
    }

    protected void buildSetMetaData() throws Throwable {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("NestedBean", NestedBean.class.getName());
        AbstractConstructorMetaData constructor1 = new AbstractConstructorMetaData();
        AbstractParameterMetaData parameter1 = new AbstractParameterMetaData(Integer.TYPE.getName(), (Object)5);
        constructor1.setParameters(Collections.singletonList(parameter1));
        metaData1.setConstructor((ConstructorMetaData)constructor1);
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("bean.bean.string", "String12"));
        metaData1.setProperties(attributes1);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1});
    }

    protected void buildInjectMetaData() throws Throwable {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("InjecteeBean", NestedBean.class.getName());
        AbstractConstructorMetaData constructor1 = new AbstractConstructorMetaData();
        AbstractParameterMetaData parameter1 = new AbstractParameterMetaData(Integer.TYPE.getName(), (Object)5);
        constructor1.setParameters(Collections.singletonList(parameter1));
        metaData1.setConstructor((ConstructorMetaData)constructor1);
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        AbstractDependencyValueMetaData injectedValue = new AbstractDependencyValueMetaData((Object)"NestedBean", "bean.bean.string");
        AbstractPropertyMetaData propertyMetaData = new AbstractPropertyMetaData("string", (ValueMetaData)injectedValue);
        attributes1.add(propertyMetaData);
        metaData1.setProperties(attributes1);
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("NestedBean", NestedBean.class.getName());
        AbstractConstructorMetaData constructor2 = new AbstractConstructorMetaData();
        AbstractParameterMetaData parameter2 = new AbstractParameterMetaData(Integer.TYPE.getName(), (Object)5);
        constructor2.setParameters(Collections.singletonList(parameter2));
        metaData2.setConstructor((ConstructorMetaData)constructor1);
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("bean.bean.string", "String1234"));
        metaData2.setProperties(attributes2);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }
}

