/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.kernel.plugins.annotations.MetaDataAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.PropertyAware;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonAnnotationAdapter<T extends MetaDataAnnotationPlugin<?, ?>, U> {
    protected Logger log = Logger.getLogger(this.getClass());
    protected Set<T> classAnnotationPlugins = new HashSet<T>();
    protected Set<T> constructorAnnotationPlugins = new HashSet<T>();
    protected Set<T> propertyAnnotationPlugins = new HashSet<T>();
    protected Set<T> methodAnnotationPlugins = new HashSet<T>();
    protected Set<T> fieldAnnotationPlugins = new HashSet<T>();

    public void addAnnotationPlugin(T plugin) {
        Set<ElementType> supported;
        if (plugin == null) {
            throw new IllegalArgumentException("Null plugin.");
        }
        Class annotation = plugin.getAnnotation();
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation class: " + plugin);
        }
        if (annotation.getAnnotation(Target.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Target annotation!"));
        }
        if (annotation.getAnnotation(Retention.class) == null) {
            this.log.warn((Object)("Annotation " + annotation + " missing @Retention annotation!"));
        }
        if ((supported = plugin.getSupportedTypes()) == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        if (supported.contains((Object)ElementType.TYPE)) {
            this.classAnnotationPlugins.add(plugin);
        }
        if (supported.contains((Object)ElementType.CONSTRUCTOR)) {
            this.constructorAnnotationPlugins.add(plugin);
        }
        if (supported.contains((Object)ElementType.METHOD)) {
            if (plugin instanceof PropertyAware) {
                this.propertyAnnotationPlugins.add(plugin);
            } else {
                this.methodAnnotationPlugins.add(plugin);
            }
        }
        if (supported.contains((Object)ElementType.FIELD)) {
            this.fieldAnnotationPlugins.add(plugin);
        }
    }

    public void removeAnnotationPlugin(T plugin) {
        if (plugin == null) {
            return;
        }
        Set<ElementType> supported = plugin.getSupportedTypes();
        if (supported == null || supported.isEmpty()) {
            throw new IllegalArgumentException("Null or empty support types: " + plugin);
        }
        if (supported.contains((Object)ElementType.TYPE)) {
            this.classAnnotationPlugins.remove(plugin);
        }
        if (supported.contains((Object)ElementType.CONSTRUCTOR)) {
            this.constructorAnnotationPlugins.remove(plugin);
        }
        if (supported.contains((Object)ElementType.METHOD)) {
            if (plugin instanceof PropertyAware) {
                this.propertyAnnotationPlugins.remove(plugin);
            } else {
                this.methodAnnotationPlugins.remove(plugin);
            }
        }
        if (supported.contains((Object)ElementType.FIELD)) {
            this.fieldAnnotationPlugins.remove(plugin);
        }
    }

    protected abstract void applyPlugin(T var1, AnnotatedInfo var2, MetaData var3, U var4) throws Throwable;

    protected abstract void cleanPlugin(T var1, AnnotatedInfo var2, MetaData var3, U var4) throws Throwable;

    protected abstract Object getName(U var1);

    protected void handleAnnotations(BeanInfo info, MetaData retrieval, U handle, boolean isApplyPhase) throws Throwable {
        MethodInfo[] staticMethods;
        Set methods;
        MetaData cmdr;
        if (info == null) {
            throw new IllegalArgumentException("Null bean info.");
        }
        if (retrieval == null) {
            throw new IllegalArgumentException("Null metadata.");
        }
        if (handle == null) {
            throw new IllegalArgumentException("Null handle.");
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)(this.getName(handle) + " apply annotations"));
        }
        ClassInfo classInfo = info.getClassInfo();
        for (MetaDataAnnotationPlugin plugin : this.classAnnotationPlugins) {
            if (isApplyPhase) {
                this.applyPlugin(plugin, (AnnotatedInfo)classInfo, retrieval, handle);
                continue;
            }
            this.cleanPlugin(plugin, (AnnotatedInfo)classInfo, retrieval, handle);
        }
        Set constructors = info.getConstructors();
        if (constructors != null && !constructors.isEmpty()) {
            for (ConstructorInfo ci : constructors) {
                ConstructorSignature cis = new ConstructorSignature(ci);
                MetaData cmdr2 = retrieval.getComponentMetaData((Signature)cis);
                if (cmdr2 != null) {
                    for (MetaDataAnnotationPlugin plugin : this.constructorAnnotationPlugins) {
                        if (isApplyPhase) {
                            this.applyPlugin(plugin, (AnnotatedInfo)ci, cmdr2, handle);
                            continue;
                        }
                        this.cleanPlugin(plugin, (AnnotatedInfo)ci, cmdr2, handle);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + ci));
            }
        } else if (trace) {
            this.log.trace((Object)"No constructors");
        }
        HashSet<MethodInfo> visitedMethods = new HashSet<MethodInfo>();
        Set properties = info.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyInfo pi : properties) {
                FieldInfo field = pi.getFieldInfo();
                if (field != null) {
                    FieldSignature sis = new FieldSignature(field);
                    cmdr = retrieval.getComponentMetaData((Signature)sis);
                    if (cmdr != null) {
                        for (MetaDataAnnotationPlugin plugin : this.fieldAnnotationPlugins) {
                            if (isApplyPhase) {
                                this.applyPlugin(plugin, (AnnotatedInfo)field, cmdr, handle);
                                continue;
                            }
                            this.cleanPlugin(plugin, (AnnotatedInfo)field, cmdr, handle);
                        }
                    } else if (trace) {
                        this.log.trace((Object)("No annotations for field " + field.getName()));
                    }
                }
                this.handleMethod(retrieval, handle, isApplyPhase, trace, visitedMethods, pi, pi.getSetter(), "setter");
                this.handleMethod(retrieval, handle, isApplyPhase, trace, visitedMethods, pi, pi.getGetter(), "getter");
            }
        } else if (trace) {
            this.log.trace((Object)"No properties");
        }
        if ((methods = info.getMethods()) != null && !methods.isEmpty()) {
            for (MethodInfo mi : methods) {
                if (visitedMethods.contains(mi)) continue;
                MethodSignature mis = new MethodSignature(mi);
                cmdr = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr != null) {
                    for (MetaDataAnnotationPlugin plugin : this.methodAnnotationPlugins) {
                        if (isApplyPhase) {
                            this.applyPlugin(plugin, (AnnotatedInfo)mi, cmdr, handle);
                            continue;
                        }
                        this.cleanPlugin(plugin, (AnnotatedInfo)mi, cmdr, handle);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + mi));
            }
        } else if (trace) {
            this.log.trace((Object)"No methods");
        }
        if ((staticMethods = this.getStaticMethods(classInfo)) != null && staticMethods.length != 0) {
            for (MethodInfo smi : staticMethods) {
                if (!smi.isStatic() || !smi.isPublic()) continue;
                MethodSignature mis = new MethodSignature(smi);
                MetaData cmdr3 = retrieval.getComponentMetaData((Signature)mis);
                if (cmdr3 != null) {
                    for (MetaDataAnnotationPlugin plugin : this.methodAnnotationPlugins) {
                        if (isApplyPhase) {
                            this.applyPlugin(plugin, (AnnotatedInfo)smi, cmdr3, handle);
                            continue;
                        }
                        this.cleanPlugin(plugin, (AnnotatedInfo)smi, cmdr3, handle);
                    }
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("No annotations for " + smi));
            }
        } else if (trace) {
            this.log.trace((Object)"No static methods");
        }
    }

    protected void handleMethod(MetaData retrieval, U handle, boolean isApplyPhase, boolean trace, Set<MethodInfo> visitedMethods, PropertyInfo pi, MethodInfo method, String type) throws Throwable {
        if (method == null) {
            return;
        }
        visitedMethods.add(method);
        MethodSignature sis = new MethodSignature(method);
        MetaData cmdr = retrieval.getComponentMetaData((Signature)sis);
        if (cmdr != null) {
            for (MetaDataAnnotationPlugin plugin : this.propertyAnnotationPlugins) {
                if (isApplyPhase) {
                    this.applyPlugin(plugin, (AnnotatedInfo)pi, cmdr, handle);
                    continue;
                }
                this.cleanPlugin(plugin, (AnnotatedInfo)pi, cmdr, handle);
            }
        } else if (trace) {
            this.log.trace((Object)("No annotations for " + type + ": " + pi.getName()));
        }
    }

    protected MethodInfo[] getStaticMethods(ClassInfo classInfo) {
        return classInfo.getDeclaredMethods();
    }
}

