/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.deployment.xml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.plugins.AbstractAnnotationMetaData;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.spring.annotations.SpringBean;
import org.jboss.spring.metadata.AbstractConstructorArg;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanHandler
extends DefaultElementHandler {
    public static final SpringBeanHandler HANDLER = new SpringBeanHandler();
    public static final String DELIMITER_PATTERN = "[,; ]";

    public Object startElement(Object parent, QName name, ElementBinding element) {
        AbstractBeanMetaData bean = new AbstractBeanMetaData();
        HashSet<AbstractAnnotationMetaData> annotations = bean.getAnnotations();
        if (annotations == null) {
            annotations = new HashSet<AbstractAnnotationMetaData>();
            bean.setAnnotations(annotations);
        }
        AbstractAnnotationMetaData springAnnotation = new AbstractAnnotationMetaData();
        springAnnotation.setAnnotation("@" + SpringBean.class.getName());
        annotations.add(springAnnotation);
        return bean;
    }

    public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
        AbstractBeanMetaData bean = (AbstractBeanMetaData)o;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String localName = attrs.getLocalName(i);
            if ("id".equals(localName)) {
                bean.setName(attrs.getValue(i));
                continue;
            }
            if ("name".equals(localName)) {
                String name = attrs.getValue(i);
                String[] names = name.split(DELIMITER_PATTERN);
                bean.setAliases(new TreeSet<String>(Arrays.asList(names)));
                continue;
            }
            if ("class".equals(localName)) {
                bean.setBean(attrs.getValue(i));
                continue;
            }
            if ("init-method".equals(localName)) {
                bean.setCreate((LifecycleMetaData)new AbstractLifecycleMetaData(attrs.getValue(i)));
                continue;
            }
            if ("lazy-init".equals(localName) && Boolean.parseBoolean(attrs.getValue(i))) {
                bean.setMode(ControllerMode.ON_DEMAND);
                continue;
            }
            if ("parent".equals(localName)) {
                bean.setParent(attrs.getValue(i));
                continue;
            }
            if ("abstract".equals(localName)) {
                bean.setAbstract(Boolean.parseBoolean(attrs.getValue(i)));
                continue;
            }
            if ("autowire".equals(localName)) {
                bean.setAutowireType(AutowireType.getInstance((String)attrs.getValue(i)));
                continue;
            }
            if ("autowire-candidate".equals(localName)) {
                bean.setAutowireCandidate(Boolean.parseBoolean(attrs.getValue(i)));
                continue;
            }
            if ("destroy-method".equals(localName)) {
                bean.setDestroy((LifecycleMetaData)new AbstractLifecycleMetaData(attrs.getValue(i)));
                continue;
            }
            if ("depends-on".equals(localName)) {
                String[] values;
                HashSet<AbstractDemandMetaData> demands = bean.getDemands();
                if (demands == null) {
                    demands = new HashSet<AbstractDemandMetaData>();
                    bean.setDemands(demands);
                }
                for (String name : values = attrs.getValue(i).split(DELIMITER_PATTERN)) {
                    demands.add(new AbstractDemandMetaData((Object)name));
                }
                continue;
            }
            if (!"factory-method".equals(localName) && !"factory-bean".equals(localName)) continue;
            AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)bean.getConstructor();
            if (constructor == null) {
                constructor = new AbstractConstructorMetaData();
                bean.setConstructor((ConstructorMetaData)constructor);
            }
            if ("factory-method".equals(localName)) {
                constructor.setFactoryMethod(attrs.getValue(i));
            }
            if (!"factory-bean".equals(localName)) continue;
            constructor.setFactory((ValueMetaData)new AbstractDependencyValueMetaData((Object)attrs.getValue(i)));
        }
    }

    public Object endElement(Object object, QName qName, ElementBinding elementBinding) {
        List parameters;
        AbstractBeanMetaData beanMetaData = (AbstractBeanMetaData)object;
        ConstructorMetaData constructor = beanMetaData.getConstructor();
        if (constructor != null && (parameters = constructor.getParameters()) != null && parameters.size() > 1) {
            this.orderParameters(parameters);
        }
        return beanMetaData;
    }

    protected void orderParameters(List<ParameterMetaData> parameters) {
        ParameterMetaData[] pmds = new ParameterMetaData[parameters.size()];
        for (ParameterMetaData pmd : parameters) {
            int index = pmd.getIndex();
            if (!(pmd instanceof AbstractConstructorArg) || !((AbstractConstructorArg)pmd).isExplicitIndex()) continue;
            if (pmds[index] != null) {
                throw new IllegalArgumentException("Argument with index: " + index + " already set!");
            }
            pmds[index] = pmd;
        }
        int index = 0;
        for (ParameterMetaData pmd : parameters) {
            if (pmd instanceof AbstractConstructorArg && !((AbstractConstructorArg)pmd).isExplicitIndex()) {
                while (pmds[index] != null) {
                    ++index;
                }
                pmds[index] = pmd;
            }
            ++index;
        }
        parameters.clear();
        parameters.addAll(Arrays.asList(pmds));
    }
}

