/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return GetContextClassLoaderAction.NOT_PRIVILEGED.getContextClassLoader();
        }
        return GetContextClassLoaderAction.PRIVILEGED.getContextClassLoader();
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NOT_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface GetClassLoaderAction {
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };
        public static final GetClassLoaderAction NOT_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }

    private static interface GetContextClassLoaderAction {
        public static final GetContextClassLoaderAction PRIVILEGED = new GetContextClassLoaderAction(){

            public ClassLoader getContextClassLoader() {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
        };
        public static final GetContextClassLoaderAction NOT_PRIVILEGED = new GetContextClassLoaderAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        };

        public ClassLoader getContextClassLoader();
    }
}

