/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.guice.spi;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.google.inject.spi.SourceProviders;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.guice.spi.BinderHolder;
import org.jboss.guice.spi.ControllerContextBindFilter;
import org.jboss.guice.spi.InjectableMicrocontainerProvider;
import org.jboss.guice.spi.MicrocontainerProvider;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.reflect.spi.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuiceIntegration
extends BinderHolder {
    private static final ControllerContextBindFilter ALL;
    private KernelController controller;

    protected GuiceIntegration(Kernel kernel, Binder binder) {
        super(binder);
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel.");
        }
        this.controller = kernel.getController();
    }

    protected KernelController getController() {
        return this.controller;
    }

    public static <T> Provider<T> fromMicrocontainer(Class<T> type, Object name) {
        return new InjectableMicrocontainerProvider<T>(type, name);
    }

    public static <T> Provider<T> fromMicrocontainer(Class<T> type) {
        return GuiceIntegration.fromMicrocontainer(type, type);
    }

    public static void bindAll(Binder binder, Controller controller) {
        GuiceIntegration.bindAll(binder, controller, ALL);
    }

    public static void bindAll(Binder binder, Controller controller, ControllerContextBindFilter filter) {
        Set installedContexts = controller.getContextsByState(ControllerState.INSTALLED);
        if (installedContexts != null && !installedContexts.isEmpty()) {
            for (ControllerContext context : installedContexts) {
                if (!filter.bind(context)) continue;
                GuiceIntegration.bindContext(binder, controller, context);
            }
        }
    }

    protected static void bindContext(Binder binder, Controller controller, ControllerContext context) {
        GenericBeanFactory gbf;
        String bean;
        Class targetClass = null;
        Object target = context.getTarget();
        if (target != null && GenericBeanFactory.class.isAssignableFrom(targetClass = target.getClass()) && (bean = (gbf = (GenericBeanFactory)target).getBean()) != null && controller instanceof KernelController) {
            try {
                ClassLoader classLoader = Configurator.getClassLoader((ClassLoaderMetaData)gbf.getClassLoader());
                KernelController kernelController = (KernelController)controller;
                KernelConfigurator configurator = kernelController.getKernel().getConfigurator();
                ClassInfo info = configurator.getClassInfo(bean, classLoader);
                targetClass = info.getType();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (targetClass != null) {
            GuiceIntegration.bindBean(binder, controller, context.getName().toString(), targetClass);
            Set aliases = context.getAliases();
            if (aliases != null && !aliases.isEmpty()) {
                for (Object alias : aliases) {
                    GuiceIntegration.bindBean(binder, controller, alias.toString(), targetClass);
                }
            }
        }
    }

    static <T> void bindBean(Binder binder, Controller controller, String name, Class<T> type) {
        MicrocontainerProvider<T> provider = new MicrocontainerProvider<T>(type, name);
        provider.initialize(controller);
        binder.bind(type).annotatedWith((Annotation)Names.named((String)name)).toProvider(provider);
    }

    static {
        SourceProviders.skip(GuiceIntegration.class);
        ALL = new ControllerContextBindFilter(){

            public boolean bind(ControllerContext context) {
                return true;
            }
        };
    }
}

