/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.SerialVersionUID;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ProxyMixin;
import org.jboss.aop.proxy.SecurityActions;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.reference.MethodPersistentReference;
import org.jboss.util.collection.WeakValueHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassProxyFactory {
    private static Object maplock = new Object();
    private static WeakValueHashMap<String, Class<?>> classnameMap = new WeakValueHashMap();
    private static WeakHashMap<ClassLoader, WeakHashMap<Class<?>, WeakReference<Class<?>>>> proxyCache = new WeakHashMap();
    private static WeakHashMap<Class<?>, Map<Long, MethodPersistentReference>> methodMapCache = new WeakHashMap();
    private static int counter = 0;

    public static ClassProxy newInstance(Class<?> clazz) throws Exception {
        return ClassProxyFactory.newInstance(clazz, null);
    }

    public static ClassProxy newInstance(Class<?> clazz, ProxyMixin[] mixins) throws Exception {
        return ClassProxyFactory.newInstance(clazz, mixins, new ClassInstanceAdvisor());
    }

    public static ClassProxy newInstance(Class<?> clazz, ProxyMixin[] mixins, boolean interceptWriteReplace) throws Exception {
        return ClassProxyFactory.newInstance(clazz, mixins, new ClassInstanceAdvisor(), interceptWriteReplace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getProxyClass(Class<?> clazz, ProxyMixin[] mixins, boolean interceptWriteReplace) throws Exception {
        ClassPool pool;
        if (ClassProxy.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
        }
        if ((pool = AspectManager.instance().findClassPool(clazz)) == null) {
            throw new NullPointerException("Could not find ClassPool");
        }
        Class proxyClass = null;
        Object object = maplock;
        synchronized (object) {
            WeakReference<Class<?>> ref;
            WeakHashMap<Class<Object>, WeakReference<Class<Object>>> proxiesForLoader = proxyCache.get(pool.getClassLoader());
            if (proxiesForLoader == null) {
                proxiesForLoader = new WeakHashMap();
                proxyCache.put(pool.getClassLoader(), proxiesForLoader);
            }
            if (proxiesForLoader != null && (ref = proxiesForLoader.get(pool.getClassLoader())) != null) {
                proxyClass = (Class)ref.get();
            }
            if (proxyClass == null) {
                proxyClass = ClassProxyFactory.generateProxy(pool, clazz, mixins, interceptWriteReplace);
                classnameMap.put((Object)clazz.getName(), (Object)proxyClass);
                proxiesForLoader.put(clazz, new WeakReference<Class>(proxyClass));
                HashMap<Long, MethodPersistentReference> map = ClassProxyFactory.methodMap(clazz);
                methodMapCache.put(proxyClass, map);
            }
        }
        return proxyClass;
    }

    public static ClassProxy newInstance(Class<?> clazz, ProxyMixin[] mixins, InstanceAdvisor advisor) throws Exception {
        return ClassProxyFactory.newInstance(clazz, mixins, advisor, false);
    }

    public static ClassProxy newInstance(Class<?> clazz, ProxyMixin[] mixins, InstanceAdvisor advisor, boolean interceptWriteReplace) throws Exception {
        Class<?> proxyClass = ClassProxyFactory.getProxyClass(clazz, mixins, interceptWriteReplace);
        ClassProxy proxy = (ClassProxy)proxyClass.newInstance();
        proxy.setMixins(mixins);
        proxy._setInstanceAdvisor(advisor);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<Long, MethodPersistentReference> getMethodMap(String classname) {
        Object object = maplock;
        synchronized (object) {
            Class clazz = (Class)classnameMap.get((Object)classname);
            if (clazz == null) {
                return null;
            }
            return (HashMap)methodMapCache.get(clazz);
        }
    }

    public static HashMap<Long, MethodPersistentReference> getMethodMap(Class<?> clazz) {
        HashMap<Long, MethodPersistentReference> map = ClassProxyFactory.getMethodMap(clazz.getName());
        if (map != null) {
            return map;
        }
        try {
            return ClassProxyFactory.methodMap(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static CtClass createProxyCtClass(ClassPool pool, ProxyMixin[] mixins, Class<?> clazz, boolean interceptWriteReplace) throws Exception {
        String classname = "AOPClassProxy$" + counter++;
        CtClass template = pool.get("org.jboss.aop.proxy.ClassProxyTemplate");
        CtClass superclass = pool.get(clazz.getName());
        CtField mixinField = template.getField("mixins");
        CtField instanceAdvisor = template.getField("instanceAdvisor");
        CtClass proxy = TransformerCommon.makeClass(pool, classname, superclass);
        mixinField = new CtField(mixinField.getType(), "mixins", proxy);
        mixinField.setModifiers(2);
        Instrumentor.addSyntheticAttribute(mixinField);
        proxy.addField(mixinField);
        instanceAdvisor = new CtField(instanceAdvisor.getType(), "instanceAdvisor", proxy);
        instanceAdvisor.setModifiers(2);
        proxy.addField(instanceAdvisor);
        CtMethod writeEx = CtNewMethod.make((String)"   public void writeExternal(java.io.ObjectOutput out)\n   throws java.io.IOException\n   {\n   }", (CtClass)proxy);
        Instrumentor.addSyntheticAttribute(writeEx);
        CtMethod readEx = CtNewMethod.make((String)"   public void readExternal(java.io.ObjectInput in)\n   throws java.io.IOException, ClassNotFoundException\n   {\n   }", (CtClass)proxy);
        Instrumentor.addSyntheticAttribute(readEx);
        CtMethod getInstanceAdvisor = CtNewMethod.make((String)"   public org.jboss.aop.InstanceAdvisor _getInstanceAdvisor()\n   {\n      return instanceAdvisor;\n   }", (CtClass)proxy);
        Instrumentor.addSyntheticAttribute(getInstanceAdvisor);
        CtMethod setInstanceAdvisor = CtNewMethod.make((String)"   public void _setInstanceAdvisor(org.jboss.aop.InstanceAdvisor newAdvisor)\n   {\n      instanceAdvisor = (org.jboss.aop.ClassInstanceAdvisor) newAdvisor;\n   }", (CtClass)proxy);
        Instrumentor.addSyntheticAttribute(setInstanceAdvisor);
        CtMethod dynamicInvoke = CtNewMethod.make((String)"   public org.jboss.aop.joinpoint.InvocationResponse _dynamicInvoke(org.jboss.aop.joinpoint.Invocation invocation)\n   throws Throwable\n   {\n      ((org.jboss.aop.joinpoint.InvocationBase) invocation).setInstanceResolver(instanceAdvisor.getMetaData());\n      org.jboss.aop.advice.Interceptor[] aspects = instanceAdvisor.getInterceptors();\n      return new org.jboss.aop.joinpoint.InvocationResponse(invocation.invokeNext(aspects));\n   }", (CtClass)proxy);
        Instrumentor.addSyntheticAttribute(dynamicInvoke);
        CtMethod setMixins = CtNewMethod.make((String)"   public void setMixins(org.jboss.aop.proxy.ProxyMixin[] mixins)\n   {\n      this.mixins = mixins;\n   }", (CtClass)proxy);
        Instrumentor.addSyntheticAttribute(setMixins);
        CtMethod writeReplace = CtNewMethod.make((String)"   public Object writeReplace() throws java.io.ObjectStreamException\n   {\n      return new org.jboss.aop.proxy.MarshalledClassProxy(this.getClass().getSuperclass(), mixins, instanceAdvisor);\n   }", (CtClass)proxy);
        Instrumentor.addSyntheticAttribute(writeReplace);
        proxy.addMethod(writeEx);
        proxy.addMethod(readEx);
        proxy.addMethod(getInstanceAdvisor);
        proxy.addMethod(setInstanceAdvisor);
        proxy.addMethod(dynamicInvoke);
        proxy.addMethod(setMixins);
        if (!interceptWriteReplace) {
            proxy.addMethod(writeReplace);
        }
        proxy.addInterface(pool.get("org.jboss.aop.proxy.ClassProxy"));
        proxy.addInterface(pool.get("java.io.Externalizable"));
        proxy.addInterface(pool.get("org.jboss.aop.instrument.Untransformable"));
        proxy.addInterface(pool.get("org.jboss.aop.proxy.MethodMapped"));
        CtClass map = pool.get("java.util.Map");
        CtField methodMap = new CtField(map, "methodMap", proxy);
        methodMap.setModifiers(10);
        proxy.addField(methodMap);
        CtMethod getMethodMap = CtNewMethod.getter((String)"getMethodMap", (CtField)methodMap);
        getMethodMap.setModifiers(1);
        proxy.addMethod(getMethodMap);
        HashSet<String> addedInterfaces = new HashSet<String>();
        HashSet<Long> addedMethods = new HashSet<Long>();
        if (mixins != null) {
            for (int i = 0; i < mixins.length; ++i) {
                HashSet<Long> mixinMethods = new HashSet<Long>();
                Class<?>[] mixinf = mixins[i].getInterfaces();
                ClassPool mixPool = AspectManager.instance().findClassPool(mixins[i].getMixin().getClass());
                CtClass mixClass = mixPool.get(mixins[i].getMixin().getClass().getName());
                for (int j = 0; j < mixinf.length; ++j) {
                    if (addedInterfaces.contains(mixinf[j].getName())) {
                        throw new Exception("2 mixins are implementing the same interfaces");
                    }
                    ClassPool mixIntfPool = AspectManager.instance().findClassPool(mixinf[j]);
                    CtClass intfClass = mixIntfPool.get(mixinf[j].getName());
                    CtMethod[] methods = intfClass.getMethods();
                    for (int m = 0; m < methods.length; ++m) {
                        Long hash;
                        if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m])))) continue;
                        if (addedMethods.contains(hash)) {
                            throw new Exception("More than one mixin has same method");
                        }
                        mixinMethods.add(hash);
                        addedMethods.add(hash);
                        String returnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ";
                        String code = "{   " + mixClass.getName() + " mixin = (" + mixClass.getName() + ")mixins[" + i + "].getMixin();" + "   " + returnStr + " mixin." + methods[m].getName() + "($$);" + "}";
                        CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)proxy);
                        newMethod.setModifiers(1);
                        proxy.addMethod(newMethod);
                    }
                    proxy.addInterface(intfClass);
                    addedInterfaces.add(intfClass.getName());
                }
            }
        }
        HashMap<Long, CtMethod> allMethods = JavassistMethodHashing.getMethodMap(superclass);
        if (interceptWriteReplace) {
            allMethods.put(JavassistMethodHashing.methodHash(writeReplace), writeReplace);
        }
        for (Map.Entry<Long, CtMethod> entry : allMethods.entrySet()) {
            Long hash;
            CtMethod m = entry.getValue();
            if (!Modifier.isPublic((int)m.getModifiers()) || Modifier.isStatic((int)m.getModifiers()) || addedMethods.contains(hash = entry.getKey())) continue;
            addedMethods.add(hash);
            String aopReturnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
            String args = "null";
            if (m.getParameterTypes().length > 0) {
                args = "$args";
            }
            String code = "{       org.jboss.aop.advice.Interceptor[] aspects = instanceAdvisor.getInterceptors();     org.jboss.aop.MethodInfo mi = new org.jboss.aop.MethodInfo();     mi.setHash(" + hash + "L);" + "    org.jboss.aop.proxy.ProxyMethodInvocation invocation = new org.jboss.aop.proxy.ProxyMethodInvocation(this, mi, aspects); " + "    invocation.setInstanceResolver(instanceAdvisor.getMetaData()); " + "    invocation.setArguments(" + args + "); " + "    " + aopReturnStr + " invocation.invokeNext(); " + "}";
            CtMethod newMethod = CtNewMethod.make((CtClass)m.getReturnType(), (String)m.getName(), (CtClass[])m.getParameterTypes(), (CtClass[])m.getExceptionTypes(), (String)code, (CtClass)proxy);
            newMethod.setModifiers(1);
            proxy.addMethod(newMethod);
        }
        SerialVersionUID.setSerialVersionUID((CtClass)proxy);
        return proxy;
    }

    private static Class<?> generateProxy(ClassPool pool, Class<?> clazz, ProxyMixin[] mixins, boolean interceptWriteReplace) throws Exception {
        CtClass proxy = ClassProxyFactory.createProxyCtClass(pool, mixins, clazz, interceptWriteReplace);
        ProtectionDomain pd = clazz.getProtectionDomain();
        Class<?> proxyClass = TransformerCommon.toClass(proxy, pd);
        HashMap<Long, MethodPersistentReference> methodmap = ClassProxyFactory.getMethodMap(proxyClass);
        Field field = proxyClass.getDeclaredField("methodMap");
        SecurityActions.setAccessible(field);
        field.set(null, methodmap);
        return proxyClass;
    }

    private static void populateMethodTables(HashMap<Long, MethodPersistentReference> advised, List<Long> ignoredHash, Class<?> superclass) throws Exception {
        if (superclass == null) {
            return;
        }
        if (superclass.getName().equals("java.lang.Object")) {
            return;
        }
        Method[] declaredMethods = superclass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            long hash;
            if (!ClassAdvisor.isAdvisable(declaredMethods[i])) continue;
            if (!java.lang.reflect.Modifier.isVolatile(declaredMethods[i].getModifiers())) {
                hash = MethodHashing.methodHash(declaredMethods[i]);
                if (ignoredHash.contains(new Long(hash))) continue;
                advised.put(new Long(hash), new MethodPersistentReference(declaredMethods[i], 1));
                continue;
            }
            hash = MethodHashing.methodHash(declaredMethods[i]);
            ignoredHash.add(new Long(hash));
        }
        ClassProxyFactory.populateMethodTables(advised, ignoredHash, superclass.getSuperclass());
    }

    public static HashMap<Long, MethodPersistentReference> methodMap(Class<?> clazz) throws Exception {
        HashMap<Long, MethodPersistentReference> methods = new HashMap<Long, MethodPersistentReference>();
        ArrayList<Long> ignoredHash = new ArrayList<Long>();
        ClassProxyFactory.populateMethodTables(methods, ignoredHash, clazz);
        return methods;
    }
}

