/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reliance.identity;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;
import org.jboss.reliance.identity.Authenticator;
import org.jboss.reliance.identity.DefaultAuthenticator;
import org.jboss.reliance.identity.SimpleGroup;
import org.jboss.reliance.identity.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicrocontainerLoginModule
implements LoginModule {
    private static final Logger log = Logger.getLogger(MicrocontainerLoginModule.class);
    protected Set<String> roles = new HashSet<String>();
    protected Subject subject;
    protected Map<String, ?> options;
    protected CallbackHandler callbackHandler;
    protected String username;
    protected String password;

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add(new SimplePrincipal(this.username));
        SimpleGroup roleGroup = null;
        for (Group g : this.subject.getPrincipals(Group.class)) {
            if (!"Roles".equalsIgnoreCase(g.getName())) continue;
            roleGroup = g;
            break;
        }
        if (roleGroup == null) {
            roleGroup = new SimpleGroup("Roles");
        }
        for (String role : this.roles) {
            roleGroup.addMember(new SimplePrincipal(role));
        }
        this.subject.getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.options = options;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        try {
            NameCallback cbName = new NameCallback("Enter username");
            PasswordCallback cbPassword = new PasswordCallback("Enter password", false);
            this.callbackHandler.handle(new Callback[]{cbName, cbPassword});
            this.username = cbName.getName();
            this.password = new String(cbPassword.getPassword());
        }
        catch (Exception ex) {
            log.error((Object)"Error logging in", (Throwable)ex);
            throw new LoginException(ex.getMessage());
        }
        Authenticator authenticator = this.getAuthenticator();
        try {
            return authenticator.authenticate(this.username, this.password);
        }
        catch (Exception ex) {
            log.error((Object)"Error invoking login method", (Throwable)ex);
            throw new LoginException(ex.getMessage());
        }
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    protected Authenticator getAuthenticator() {
        return DefaultAuthenticator.INSTANCE;
    }
}

